/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.objects;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.orion.server.core.resources.Property;
import org.eclipse.orion.server.core.resources.ResourceShape;
import org.eclipse.orion.server.core.resources.annotations.PropertyDescription;
import org.eclipse.orion.server.core.resources.annotations.ResourceDescription;
import org.eclipse.orion.server.git.BaseToCommitConverter;
import org.eclipse.orion.server.git.BaseToIndexConverter;
import org.eclipse.orion.server.git.BaseToRemoteConverter;
import org.eclipse.orion.server.git.objects.GitObject;
import org.eclipse.orion.server.git.objects.Remote;
import org.eclipse.orion.server.git.servlets.GitUtils;
import org.json.JSONException;
import org.json.JSONObject;

@ResourceDescription(type="RemoteTrackingBranch")
public class RemoteBranch
extends GitObject {
    public static final String TYPE = "RemoteTrackingBranch";
    private static final ResourceShape DEFAULT_RESOURCE_SHAPE = new ResourceShape();
    private Remote remote;
    private String name;
    private Ref ref;

    public RemoteBranch(URI cloneLocation, Repository db, Remote remote, String name) {
        super(cloneLocation, db);
        Property[] defaultProperties = new Property[]{new Property("Location"), new Property("CloneLocation"), new Property("Name"), new Property("FullName"), new Property("Id"), new Property("CommitLocation"), new Property("TreeLocation"), new Property("HeadLocation"), new Property("IndexLocation"), new Property("GitUrl"), new Property("DiffLocation")};
        DEFAULT_RESOURCE_SHAPE.setProperties(defaultProperties);
        this.remote = remote;
        this.name = name;
        this.ref = this.findRef();
    }

    public RemoteBranch(URI cloneLocation, Repository db, Remote remote, String name, Ref ref) {
        super(cloneLocation, db);
        Property[] defaultProperties = new Property[]{new Property("Location"), new Property("CloneLocation"), new Property("Name"), new Property("FullName"), new Property("Id"), new Property("CommitLocation"), new Property("TreeLocation"), new Property("HeadLocation"), new Property("IndexLocation"), new Property("GitUrl"), new Property("DiffLocation")};
        DEFAULT_RESOURCE_SHAPE.setProperties(defaultProperties);
        this.remote = remote;
        this.name = name;
        this.ref = ref;
    }

    private Ref findRef() {
        try {
            Set configNames = this.getConfig().getSubsections("remote");
            for (String configName : configNames) {
                if (!configName.equals(this.remote.getName())) continue;
                String fullName = this.getName(true, false);
                Ref ref = this.db.getRefDatabase().getRef(fullName);
                if (ref == null || ref.isSymbolic()) continue;
                return ref;
            }
        }
        catch (IOException iOException) {}
        return null;
    }

    @Override
    public JSONObject toJSON() throws JSONException, URISyntaxException, IOException, CoreException {
        return (JSONObject)this.jsonSerializer.serialize((Object)this, DEFAULT_RESOURCE_SHAPE);
    }

    @PropertyDescription(name="DiffLocation")
    private URI getDiffLocation() throws URISyntaxException {
        Assert.isNotNull((Object)this.cloneLocation);
        Path basePath = new Path(this.cloneLocation.getPath());
        IPath p = new Path("/gitapi").append("diff").append(this.getName(false, true)).append(basePath.removeFirstSegments(2));
        return new URI(this.cloneLocation.getScheme(), this.cloneLocation.getUserInfo(), this.cloneLocation.getHost(), this.cloneLocation.getPort(), p.toString(), this.cloneLocation.getQuery(), this.cloneLocation.getFragment());
    }

    @PropertyDescription(name="Name")
    private String getName() {
        return this.getName(false, false);
    }

    @PropertyDescription(name="FullName")
    private String getFullName() {
        return this.getName(true, false);
    }

    @PropertyDescription(name="Id")
    private String getId() {
        return this.ref.getObjectId().name();
    }

    @PropertyDescription(name="GitUrl")
    private String getUrl() {
        return this.getConfig().getString("remote", this.remote.getName(), "url");
    }

    private String getName(boolean fullName, boolean encode) {
        String name = "refs/remotes/" + this.remote.getName() + "/" + this.name;
        if (!fullName) {
            name = Repository.shortenRefName((String)name);
        }
        if (encode) {
            name = GitUtils.encode(name);
        }
        return name;
    }

    @PropertyDescription(name="CommitLocation")
    private URI getCommitLocation() throws IOException, URISyntaxException {
        return BaseToCommitConverter.getCommitLocation(this.cloneLocation, this.getName(true, true), BaseToCommitConverter.REMOVE_FIRST_2);
    }

    @PropertyDescription(name="TreeLocation")
    private URI getTreeLocation() throws URISyntaxException {
        return this.createTreeLocation(null);
    }

    private URI createTreeLocation(String path) throws URISyntaxException {
        IPath clonePath = new Path(this.cloneLocation.getPath()).removeFirstSegments(2);
        IPath result = new Path("/gitapi").append("tree").append(clonePath).append(GitUtils.encode(this.getName()));
        if (path != null) {
            result.append(path);
        }
        return new URI(this.cloneLocation.getScheme(), this.cloneLocation.getUserInfo(), this.cloneLocation.getHost(), this.cloneLocation.getPort(), result.makeAbsolute().toString(), this.cloneLocation.getQuery(), this.cloneLocation.getFragment());
    }

    @PropertyDescription(name="HeadLocation")
    private URI getHeadLocation() throws IOException, URISyntaxException {
        return BaseToCommitConverter.getCommitLocation(this.cloneLocation, "HEAD", BaseToCommitConverter.REMOVE_FIRST_2);
    }

    @PropertyDescription(name="IndexLocation")
    private URI getIndexLocation() throws IOException, URISyntaxException {
        return BaseToIndexConverter.getIndexLocation(this.cloneLocation, BaseToIndexConverter.CLONE);
    }

    @Override
    public URI getLocation() throws URISyntaxException {
        if (this.cloneLocation == null) {
            return null;
        }
        return BaseToRemoteConverter.REMOVE_FIRST_2.baseToRemoteLocation(this.cloneLocation, this.remote.getName(), GitUtils.encode(this.name));
    }

    public String toString() {
        return "RemoteBranch [remote=" + this.remote + ", name=" + this.name + "]";
    }

    public boolean exists() {
        return this.ref != null;
    }
}

