/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.jobs;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.Cookie;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.git.GitCredentialsProvider;
import org.eclipse.orion.server.git.IGitHubTokenProvider;
import org.eclipse.orion.server.git.jobs.GitJob;
import org.eclipse.orion.server.git.servlets.GitUtils;
import org.eclipse.osgi.util.NLS;
import org.json.JSONObject;

public class PushJob
extends GitJob {
    private Path path;
    private String remote;
    private String branch;
    private String srcRef;
    private boolean tags;
    private boolean force;

    public PushJob(String userRunningTask, CredentialsProvider credentials, Path path, String srcRef, boolean tags, boolean force) {
        super(userRunningTask, true, (GitCredentialsProvider)credentials);
        this.path = path;
        this.remote = path.segment(0);
        this.branch = GitUtils.decode(path.segment(1));
        this.srcRef = srcRef;
        this.tags = tags;
        this.force = force;
        this.setFinalMessage(NLS.bind((String)"Pushing {0} done", (Object)path.segment(0)));
        this.setTaskExpirationTime(TimeUnit.DAYS.toMillis(7L));
    }

    public PushJob(String userRunningTask, CredentialsProvider credentials, Path path, String srcRef, boolean tags, boolean force, Object cookie) {
        this(userRunningTask, credentials, path, srcRef, tags, force);
        this.cookie = (Cookie)cookie;
    }

    /*
     * Exception decompiling
     */
    private IStatus doPush(IProgressMonitor monitor) throws IOException, CoreException, URISyntaxException, GitAPIException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 6[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IStatus performJob(IProgressMonitor monitor) {
        IStatus result;
        block14: {
            Repository db;
            result = Status.OK_STATUS;
            try {
                return this.doPush(monitor);
            }
            catch (CoreException e) {
                return e.getStatus();
            }
            catch (InvalidRemoteException e) {
                result = new Status(4, "org.eclipse.orion.server.git", "Error pushing git remote", (Throwable)e);
                LogHelper.log((IStatus)result);
                return result;
            }
            catch (GitAPIException e) {
                result = this.getGitAPIExceptionStatus(e, "Error pushing git remote");
                if (!PushJob.matchMessage(JGitText.get().notAuthorized, e.getCause().getMessage())) break block14;
                db = null;
                try {
                    try {
                        File gitDir = GitUtils.getGitDir(this.path.removeFirstSegments(2));
                        db = FileRepositoryBuilder.create((File)gitDir);
                        Git git = Git.wrap((Repository)db);
                        RemoteConfig remoteConfig = new RemoteConfig((Config)git.getRepository().getConfig(), this.remote);
                        String repositoryUrl = ((URIish)remoteConfig.getURIs().get(0)).toString();
                        Enumeration<IGitHubTokenProvider> providers = GitCredentialsProvider.GetGitHubTokenProviders();
                        while (providers.hasMoreElements()) {
                            String authUrl = providers.nextElement().getAuthUrl(repositoryUrl, this.cookie);
                            if (authUrl == null) continue;
                            ServerStatus status = ServerStatus.convert((IStatus)result);
                            JSONObject data = status.getJsonData();
                            data.put("GitHubAuth", (Object)authUrl);
                        }
                    }
                    catch (Exception exception) {
                        if (db != null) {
                            db.close();
                        }
                        break block14;
                    }
                }
                catch (Throwable throwable) {
                    if (db == null) throw throwable;
                    db.close();
                    throw throwable;
                }
            }
            catch (JGitInternalException e) {
                result = this.getJGitInternalExceptionStatus(e, "Error pushing git remote");
                LogHelper.log((IStatus)result);
                return result;
            }
            catch (IOException e) {
                result = new Status(4, "org.eclipse.orion.server.git", "Error pushing git remote", (Throwable)e);
                LogHelper.log((IStatus)result);
                return result;
            }
            catch (Exception e) {
                result = new Status(4, "org.eclipse.orion.server.git", "Error pushing git repository", (Throwable)e);
                LogHelper.log((IStatus)result);
                return result;
            }
            if (db != null) {
                db.close();
            }
        }
        LogHelper.log((IStatus)result);
        return result;
    }
}

