/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.ui;

import java.util.Collection;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.orion.internal.server.ui.Activator;
import org.eclipse.orion.internal.server.ui.ApplicationWorkbenchAdvisor;
import org.eclipse.orion.internal.server.ui.console.OSGiConsoleFactory;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.application.ApplicationDescriptor;
import org.osgi.service.application.ApplicationException;
import org.osgi.service.application.ApplicationHandle;

public class Application
implements IApplication {
    private static final String ORION_APP = "org.eclipse.orion.application";

    public Object start(IApplicationContext context) {
        Display display = PlatformUI.createDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                Application.this.launchOrionApplication();
                new OSGiConsoleFactory().openConsole();
            }
        });
        try {
            int returnCode = PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)new ApplicationWorkbenchAdvisor());
            if (returnCode == 1) {
                Integer n = IApplication.EXIT_RESTART;
                return n;
            }
            Integer n = IApplication.EXIT_OK;
            return n;
        }
        finally {
            display.dispose();
        }
    }

    public void stop() {
        if (!PlatformUI.isWorkbenchRunning()) {
            return;
        }
        final IWorkbench workbench = PlatformUI.getWorkbench();
        final Display display = workbench.getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                if (!display.isDisposed()) {
                    workbench.close();
                }
            }
        });
    }

    protected ApplicationHandle launchOrionApplication() {
        String filter = "(service.pid=org.eclipse.orion.application)";
        ApplicationDescriptor descriptor = this.getService(ApplicationDescriptor.class, filter);
        try {
            return descriptor.launch(null);
        }
        catch (ApplicationException e) {
            e.printStackTrace();
            return null;
        }
    }

    private <S> S getService(Class<S> clazz, String filter) {
        Collection references;
        BundleContext context = Activator.getContext();
        if (context == null) {
            return null;
        }
        try {
            references = context.getServiceReferences(clazz, filter);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            return null;
        }
        if (references == null || references.size() == 0) {
            return null;
        }
        ServiceReference ref = (ServiceReference)references.iterator().next();
        Object result = context.getService(ref);
        context.ungetService(ref);
        return (S)result;
    }
}

