/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.logs.servlets;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.rolling.RollingFileAppender;
import java.io.File;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.logs.ILogService;
import org.eclipse.orion.server.logs.LogUtils;
import org.eclipse.orion.server.logs.servlets.AbstractLogHandler;
import org.eclipse.osgi.util.NLS;

public class ArchivedLogFileHandler
extends AbstractLogHandler {
    public ArchivedLogFileHandler(ServletResourceHandler<IStatus> statusHandler) {
        super(statusHandler);
    }

    @Override
    protected boolean handleGet(HttpServletRequest request, HttpServletResponse response, ILogService logService, IPath path) throws ServletException {
        String appenderName = path.segment(0);
        String logFileName = path.segment(1);
        RollingFileAppender<ILoggingEvent> appender = logService.getRollingFileAppender(appenderName);
        if (appender == null) {
            String msg = NLS.bind((String)"Appender not found: {0}", (Object)appenderName);
            ServerStatus error = new ServerStatus(4, 404, msg, null);
            return this.statusHandler.handleRequest(request, response, (Object)error);
        }
        File logFile = logService.getArchivedLogFile(appender, logFileName);
        if (logFile == null) {
            String msg = NLS.bind((String)"Log file not found: {0}", (Object)logFileName);
            ServerStatus error = new ServerStatus(4, 404, msg, null);
            return this.statusHandler.handleRequest(request, response, (Object)error);
        }
        try {
            LogUtils.provideLogFile(logFile, response);
        }
        catch (Exception ex) {
            String msg = NLS.bind((String)"An error occured when looking for log {0}.", (Object)logFile.getName());
            ServerStatus error = new ServerStatus(4, 500, msg, (Throwable)ex);
            LogHelper.log((IStatus)error);
            return this.statusHandler.handleRequest(request, response, (Object)error);
        }
        return true;
    }
}

