/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.manifest.v2.utils;

import java.util.Iterator;
import org.eclipse.orion.server.cf.manifest.v2.Analyzer;
import org.eclipse.orion.server.cf.manifest.v2.AnalyzerException;
import org.eclipse.orion.server.cf.manifest.v2.InvalidAccessException;
import org.eclipse.orion.server.cf.manifest.v2.ManifestParseTree;

public class ApplicationReconstructor
implements Analyzer {
    @Override
    public void apply(ManifestParseTree node) throws AnalyzerException {
        if (!node.has("applications")) {
            return;
        }
        try {
            ManifestParseTree applications = node.get("applications");
            for (ManifestParseTree application : applications.getChildren()) {
                this.removeEmptyProperties(application);
                this.ensureStringProperty(application, application.getOpt("name"));
                this.ensureStringProperty(application, application.getOpt("buildpack"));
                this.ensureStringProperty(application, application.getOpt("command"));
                this.ensureStringProperty(application, application.getOpt("domain"));
                this.ensureStringProperty(application, application.getOpt("host"));
                this.ensureStringProperty(application, application.getOpt("path"));
                this.ensureMemoryProperty(application, application.getOpt("memory"));
                this.ensureNonNegativeProperty(application, application.getOpt("instances"));
                this.ensureNonNegativeProperty(application, application.getOpt("timeout"));
                this.ensureNoRouteProperty(application, application.getOpt("no-route"));
                this.ensureServicesProperty(application, application.getOpt("services"));
            }
        }
        catch (InvalidAccessException ex) {
            throw new AnalyzerException(ex.getMessage());
        }
    }

    protected void removeEmptyProperties(ManifestParseTree application) throws AnalyzerException {
        Iterator<ManifestParseTree> it = application.getChildren().iterator();
        while (it.hasNext()) {
            ManifestParseTree node = it.next();
            if (!node.getChildren().isEmpty()) continue;
            it.remove();
        }
    }

    protected void ensureStringProperty(ManifestParseTree parent, ManifestParseTree node) {
        if (node == null) {
            return;
        }
        if (!node.isStringProperty()) {
            parent.getChildren().remove(node);
        }
    }

    protected void ensureMemoryProperty(ManifestParseTree parent, ManifestParseTree node) {
        if (node == null) {
            return;
        }
        if (!node.isValidMemoryProperty()) {
            parent.getChildren().remove(node);
        }
    }

    protected void ensureNonNegativeProperty(ManifestParseTree parent, ManifestParseTree node) {
        if (node == null) {
            return;
        }
        if (!node.isValidNonNegativeProperty()) {
            parent.getChildren().remove(node);
        }
    }

    protected void ensureNoRouteProperty(ManifestParseTree parent, ManifestParseTree node) {
        if (node == null) {
            return;
        }
        if (!node.isStringProperty()) {
            parent.getChildren().remove(node);
        }
        try {
            String noRouteValue = node.getValue();
            if (!"true".equals(noRouteValue)) {
                parent.getChildren().remove(node);
            }
        }
        catch (InvalidAccessException invalidAccessException) {
            parent.getChildren().remove(node);
        }
    }

    protected void ensureServicesProperty(ManifestParseTree parent, ManifestParseTree node) {
        if (node == null) {
            return;
        }
        if (node.isStringProperty()) {
            parent.getChildren().remove(node);
        }
    }
}

