/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.logs.servlets;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.server.logs.ILogService;
import org.eclipse.orion.server.logs.LogsActivator;

public abstract class AbstractLogHandler
extends ServletResourceHandler<IPath> {
    protected final ServletResourceHandler<IStatus> statusHandler;

    public AbstractLogHandler(ServletResourceHandler<IStatus> statusHandler) {
        this.statusHandler = statusHandler;
    }

    public boolean handleRequest(HttpServletRequest request, HttpServletResponse response, IPath path) throws ServletException {
        ILogService logService = LogsActivator.getDefault().getLogService();
        if (logService == null) {
            return false;
        }
        switch (AbstractLogHandler.getMethod((HttpServletRequest)request)) {
            case GET: {
                if (path.isEmpty()) {
                    return this.handleGet(request, response, logService);
                }
                return this.handleGet(request, response, logService, path);
            }
            case POST: {
                return this.handlePost(request, response, logService, path);
            }
            case PUT: {
                return this.handlePut(request, response, logService, path);
            }
            case DELETE: {
                return this.handleDelete(request, response, logService, path);
            }
        }
        return false;
    }

    protected boolean handleGet(HttpServletRequest request, HttpServletResponse response, ILogService logService, IPath path) throws ServletException {
        return false;
    }

    protected boolean handleGet(HttpServletRequest request, HttpServletResponse response, ILogService logService) throws ServletException {
        return false;
    }

    protected boolean handlePost(HttpServletRequest request, HttpServletResponse response, ILogService logService, IPath path) throws ServletException {
        return false;
    }

    protected boolean handlePut(HttpServletRequest request, HttpServletResponse response, ILogService logService, IPath path) throws ServletException {
        return false;
    }

    protected boolean handleDelete(HttpServletRequest request, HttpServletResponse response, ILogService logService, IPath path) throws ServletException {
        return false;
    }
}

