/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets.xfer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.internal.server.servlets.file.NewFileServlet;
import org.eclipse.orion.server.core.IOUtilities;

public class ClientExport {
    private final IPath sourcePath;
    private List<String> excludedFiles = new ArrayList<String>();

    public ClientExport(IPath path, ServletResourceHandler<IStatus> statusHandler) {
        this.sourcePath = path;
    }

    public void doExport(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        IFileStore source = NewFileServlet.getFileStore(req, this.sourcePath);
        if (req.getParameter("exclude") != null) {
            this.excludedFiles = Arrays.asList(req.getParameter("exclude").split(","));
        }
        try {
            if (source.fetchInfo(0, null).isDirectory() && source.childNames(0, null).length == 0) {
                resp.sendError(405, "You cannot export an empty folder");
                return;
            }
            resp.setHeader("Cache-Control", "no-cache");
            ZipOutputStream zout = new ZipOutputStream((OutputStream)resp.getOutputStream());
            this.write(source, (IPath)Path.EMPTY, zout);
            zout.finish();
        }
        catch (CoreException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private void write(IFileStore source, IPath path, ZipOutputStream zout) throws IOException, CoreException {
        IFileInfo info = source.fetchInfo(0, null);
        if (info.isDirectory()) {
            if (!path.isEmpty()) {
                ZipEntry entry = new ZipEntry(String.valueOf(path.toString()) + "/");
                zout.putNextEntry(entry);
            }
            IFileStore[] iFileStoreArray = source.childStores(0, null);
            int n = iFileStoreArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFileStore child = iFileStoreArray[n2];
                if (!this.excludedFiles.contains(child.getName())) {
                    this.write(child, path.append(child.getName()), zout);
                }
                ++n2;
            }
        } else {
            ZipEntry entry = new ZipEntry(path.toString());
            zout.putNextEntry(entry);
            IOUtilities.pipe((InputStream)source.openInputStream(0, null), (OutputStream)zout, (boolean)true, (boolean)false);
        }
    }
}

