/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.cli;

import java.util.Collection;
import org.eclipse.passage.lic.api.agreements.AgreementToAccept;
import org.eclipse.passage.lic.api.diagnostic.Diagnostic;
import org.eclipse.passage.lic.cli.CoverageCheckOptionDecision;
import org.eclipse.passage.lic.cli.LicenseCoverageCheckOption;
import org.eclipse.passage.lic.cli.Option;
import org.eclipse.passage.lic.cli.OptionAccept;
import org.eclipse.passage.lic.cli.OptionDiagnostic;
import org.eclipse.passage.lic.cli.OptionImport;
import org.eclipse.passage.lic.cli.OptionProceed;
import org.eclipse.passage.lic.cli.OptionQuit;
import org.eclipse.passage.lic.cli.OptionRequest;
import org.eclipse.passage.lic.cli.Product;
import org.eclipse.passage.lic.cli.TheOtherSide;

public interface OptionDefinitions {
    public Option<LicenseCoverageCheckOption, CoverageCheckOptionDecision> accept(Collection<AgreementToAccept> var1);

    public Option<LicenseCoverageCheckOption, CoverageCheckOptionDecision> diagnostic(Diagnostic var1);

    public Option<LicenseCoverageCheckOption, CoverageCheckOptionDecision> licenseImport();

    public Option<LicenseCoverageCheckOption, CoverageCheckOptionDecision> licenseRequest();

    public Option<LicenseCoverageCheckOption, CoverageCheckOptionDecision> proceed(String var1);

    public Option<LicenseCoverageCheckOption, CoverageCheckOptionDecision> quit();

    public static final class Default
    implements OptionDefinitions {
        private final TheOtherSide communication;

        public Default(TheOtherSide communication) {
            this.communication = communication;
        }

        @Override
        public Option<LicenseCoverageCheckOption, CoverageCheckOptionDecision> accept(Collection<AgreementToAccept> agreements) {
            return new OptionAccept(this.communication, agreements, new Product().get());
        }

        @Override
        public Option<LicenseCoverageCheckOption, CoverageCheckOptionDecision> diagnostic(Diagnostic diagnostic) {
            return new OptionDiagnostic(this.communication, diagnostic);
        }

        @Override
        public Option<LicenseCoverageCheckOption, CoverageCheckOptionDecision> licenseImport() {
            return new OptionImport(this.communication, new Product().get());
        }

        @Override
        public Option<LicenseCoverageCheckOption, CoverageCheckOptionDecision> licenseRequest() {
            return new OptionRequest(this.communication);
        }

        @Override
        public Option<LicenseCoverageCheckOption, CoverageCheckOptionDecision> proceed(String name) {
            return new OptionProceed(name, this.communication);
        }

        @Override
        public Option<LicenseCoverageCheckOption, CoverageCheckOptionDecision> quit() {
            return new OptionQuit(this.communication);
        }
    }
}

