/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.navigator;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.IColorDecorator;
import org.eclipse.jface.viewers.IFontDecorator;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewPhase;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewState;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIAnomalyExtended;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIFileContext;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewBasic;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.CommandUtils;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class ReviewNavigatorDecorator
implements ILabelDecorator,
IFontDecorator,
IColorDecorator {
    private static final String DECORATOR_DISABLED_ID = "Disabled";
    private static final String DECORATOR_REVIEWED_ID = "Reviewed";
    private static final String DECORATOR_ADDED_ID = "Added";
    private static final String DECORATOR_REMOVED_ID = "Removed";
    private static final String DECORATOR_READONLY_ID = "Readonly";
    private static final String DECORATOR_OVERDUE_ID = "Overdue";

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Image decorateImage(Image aBaseImage, Object aElement) {
        Image currentOverlayImage = aBaseImage != null ? aBaseImage : ((IR4EUIModelElement)aElement).getImage(((IR4EUIModelElement)aElement).getImageLocation());
        ImageDescriptor topLeftOverlay = null;
        String topLeftOverlayId = "";
        ImageDescriptor topRightOverlay = null;
        String topRightOverlayId = "";
        ImageDescriptor bottomLeftOverlay = null;
        String bottomLeftOverlayId = "";
        ImageDescriptor bottomRightOverlay = null;
        String bottomRightOverlayId = "";
        ImageRegistry registry = R4EUIPlugin.getDefault().getImageRegistry();
        if (!((IR4EUIModelElement)aElement).isEnabled()) {
            bottomRightOverlay = ImageDescriptor.createFromImage((Image)((IR4EUIModelElement)aElement).getDisabledImage());
            bottomRightOverlayId = DECORATOR_DISABLED_ID;
        } else {
            if (((IR4EUIModelElement)aElement).isUserReviewed() || aElement instanceof R4EUIAnomalyExtended && ((R4EUIAnomalyExtended)aElement).isTerminalState()) {
                bottomRightOverlay = ImageDescriptor.createFromImage((Image)((IR4EUIModelElement)aElement).getUserReviewedImage());
                bottomRightOverlayId = DECORATOR_REVIEWED_ID;
            }
            if (aElement instanceof R4EUIFileContext) {
                if (((R4EUIFileContext)aElement).getBaseFileVersion() == null && ((R4EUIFileContext)aElement).getTargetFileVersion() != null) {
                    bottomLeftOverlay = ImageDescriptor.createFromImage((Image)((R4EUIFileContext)aElement).getAddedImage());
                    bottomLeftOverlayId = DECORATOR_ADDED_ID;
                } else if (((R4EUIFileContext)aElement).getBaseFileVersion() != null && ((R4EUIFileContext)aElement).getTargetFileVersion() == null) {
                    bottomLeftOverlay = ImageDescriptor.createFromImage((Image)((R4EUIFileContext)aElement).getRemovedImage());
                    bottomLeftOverlayId = DECORATOR_REMOVED_ID;
                }
            }
            if (((IR4EUIModelElement)aElement).isReadOnly()) {
                topRightOverlay = ImageDescriptor.createFromImage((Image)((IR4EUIModelElement)aElement).getReadOnlyImage());
                topRightOverlayId = DECORATOR_READONLY_ID;
            }
            if (((IR4EUIModelElement)aElement).isDueDatePassed()) {
                topLeftOverlay = ImageDescriptor.createFromImage((Image)((IR4EUIModelElement)aElement).getDueDatePassedImage());
                topLeftOverlayId = DECORATOR_OVERDUE_ID;
            }
        }
        String baseImageId = ((IR4EUIModelElement)aElement).getImageLocation();
        String decoratedImageId = String.valueOf(baseImageId) + topLeftOverlayId + topRightOverlayId + bottomLeftOverlayId + bottomRightOverlayId;
        if (registry.get(decoratedImageId) == null) {
            ImageDescriptor[] imageDescriptorArray = new ImageDescriptor[5];
            imageDescriptorArray[0] = topLeftOverlay;
            imageDescriptorArray[1] = topRightOverlay;
            imageDescriptorArray[2] = bottomLeftOverlay;
            imageDescriptorArray[3] = bottomRightOverlay;
            DecorationOverlayIcon decoratedImage = new DecorationOverlayIcon(currentOverlayImage, imageDescriptorArray){};
            registry.put(decoratedImageId, (ImageDescriptor)decoratedImage);
        }
        return registry.get(decoratedImageId);
    }

    public String decorateText(String aText, Object aElement) {
        if (aElement instanceof R4EUIFileContext && !CommandUtils.useWorkspaceResource(((R4EUIFileContext)aElement).getTargetFileVersion())) {
            return "> " + aText;
        }
        return null;
    }

    public Font decorateFont(Object aElement) {
        if (R4EUIModelController.getActiveReview() != null && R4EUIModelController.getActiveReview().equals(aElement)) {
            return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
        }
        if (this.isMyReview((IR4EUIModelElement)aElement)) {
            return JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.defaultfont");
        }
        return null;
    }

    private boolean isMyReview(IR4EUIModelElement aElement) {
        IR4EUIModelElement currentElement = aElement;
        while (currentElement != null) {
            if (currentElement instanceof R4EUIReviewBasic && ((R4EUIReviewBasic)currentElement).isParticipant(R4EUIModelController.getReviewer())) {
                return true;
            }
            currentElement = currentElement.getParent();
        }
        return false;
    }

    public Color decorateBackground(Object aElement) {
        return null;
    }

    public Color decorateForeground(Object aElement) {
        if (aElement instanceof R4EUIReviewBasic && ((R4EReviewState)((R4EUIReviewBasic)aElement).getReview().getState()).getState().equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_COMPLETED)) {
            return Display.getCurrent().getSystemColor(16);
        }
        if (aElement instanceof IR4EUIModelElement) {
            if (((IR4EUIModelElement)aElement).isDueDatePassed()) {
                return Display.getCurrent().getSystemColor(4);
            }
            if (((IR4EUIModelElement)aElement).isReadOnly()) {
                return Display.getCurrent().getSystemColor(16);
            }
        }
        return null;
    }
}

