/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.properties.tabbed;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.mylyn.reviews.frame.core.model.CommentType;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EAnomaly;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EAnomalyState;
import org.eclipse.mylyn.reviews.r4e.core.model.R4ECommentType;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewPhase;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewState;
import org.eclipse.mylyn.reviews.r4e.core.model.RModelFactory;
import org.eclipse.mylyn.reviews.r4e.core.model.drules.R4EDesignRule;
import org.eclipse.mylyn.reviews.r4e.core.model.drules.R4EDesignRuleClass;
import org.eclipse.mylyn.reviews.r4e.core.model.drules.R4EDesignRuleRank;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.Persistence;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.CompatibilityException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.OutOfSyncException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.ResourceHandlingException;
import org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs.IAnomalyInputDialog;
import org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs.ICalendarDialog;
import org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs.R4EUIDialogFactory;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIPosition;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIAnomalyBasic;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIAnomalyExtended;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIPostponedAnomaly;
import org.eclipse.mylyn.reviews.r4e.ui.internal.properties.tabbed.ModelElementTabPropertySection;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.UIUtils;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class PostponedAnomalyTabPropertySection
extends ModelElementTabPropertySection {
    private static final String ANOMALY_DETAILS_SECTION_LABEL = "Anomaly Details";
    private static final String PARTICIPANT_DETAILS_SECTION_LABEL = "Participants Details";
    protected Text fReviewNameText = null;
    private IR4EUIPosition fPosition;
    protected Text fTitleText = null;
    protected Text fAuthorText = null;
    protected Text fCreationDateText = null;
    protected Text fPositionText = null;
    protected Text fDescriptionText = null;
    private CLabel fStateLabel = null;
    protected CCombo fStateCombo = null;
    protected CCombo fClassCombo = null;
    protected CCombo fRankCombo = null;
    protected Text fRuleId = null;
    protected Button fRuleButton = null;
    protected Text fDateText = null;
    protected Button fCalendarButton = null;
    private CLabel fDecidedByLabel = null;
    protected CCombo fDecidedByCombo = null;
    private CLabel fFixedByLabel = null;
    protected CCombo fFixedByCombo = null;
    private CLabel fFollowUpByLabel = null;
    protected CCombo fFollowUpByCombo = null;
    private CCombo fAssignedToCombo;

    public boolean shouldUseExtraSpace() {
        return true;
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        TabbedPropertySheetWidgetFactory widgetFactory = aTabbedPropertySheetPage.getWidgetFactory();
        Composite composite = widgetFactory.createFlatFormComposite(parent);
        FormData data = null;
        widgetFactory.setBorderStyle(0);
        this.fReviewNameText = widgetFactory.createText(composite, "", 0);
        data = new FormData();
        data.left = new FormAttachment(0, 150);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)composite, 4);
        this.fReviewNameText.setEditable(false);
        this.fReviewNameText.setToolTipText("The name of the review where the original postponed anomaly was raised");
        this.fReviewNameText.setLayoutData((Object)data);
        CLabel reviewNameLabel = widgetFactory.createCLabel(composite, "Original Review: ");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.fReviewNameText, -5);
        data.top = new FormAttachment((Control)this.fReviewNameText, 0, 0x1000000);
        reviewNameLabel.setToolTipText("The name of the review where the original postponed anomaly was raised");
        reviewNameLabel.setLayoutData((Object)data);
        widgetFactory.setBorderStyle(2048);
        this.fTitleText = widgetFactory.createText(composite, "", 2);
        data = new FormData();
        data.left = new FormAttachment(0, 150);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.fReviewNameText, 4);
        this.fTitleText.setToolTipText("A Title that Identifies this Anomaly");
        this.fTitleText.setLayoutData((Object)data);
        this.fTitleText.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                try {
                    if (!PostponedAnomalyTabPropertySection.this.fRefreshInProgress) {
                        String currentUser = R4EUIModelController.getReviewer();
                        R4EAnomaly modelAnomaly = ((R4EUIAnomalyBasic)PostponedAnomalyTabPropertySection.this.fProperties.getElement()).getAnomaly();
                        String newValue = PostponedAnomalyTabPropertySection.this.fTitleText.getText().trim();
                        if (!newValue.equals(modelAnomaly.getTitle()) && ((R4EUIPostponedAnomaly)PostponedAnomalyTabPropertySection.this.fProperties.getElement()).checkCompatibility()) {
                            Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)modelAnomaly, currentUser);
                            modelAnomaly.setTitle(PostponedAnomalyTabPropertySection.this.fTitleText.getText());
                            R4EUIModelController.FResourceUpdater.checkIn(bookNum);
                            if (PostponedAnomalyTabPropertySection.this.fProperties.getElement() instanceof R4EUIAnomalyExtended) {
                                PostponedAnomalyTabPropertySection.this.fProperties.getElement().setName(R4EUIAnomalyExtended.buildAnomalyExtName(modelAnomaly, ((R4EUIAnomalyExtended)PostponedAnomalyTabPropertySection.this.fProperties.getElement()).getPosition()));
                            } else {
                                PostponedAnomalyTabPropertySection.this.fProperties.getElement().setName(R4EUIAnomalyBasic.buildAnomalyName(modelAnomaly, ((R4EUIAnomalyBasic)PostponedAnomalyTabPropertySection.this.fProperties.getElement()).getPosition()));
                            }
                        }
                    }
                }
                catch (ResourceHandlingException e1) {
                    UIUtils.displayResourceErrorDialog(e1);
                }
                catch (OutOfSyncException e1) {
                    UIUtils.displaySyncErrorDialog(e1);
                }
                catch (CompatibilityException e1) {
                    UIUtils.displayCompatibilityErrorDialog(e1);
                }
                R4EUIModelController.getNavigatorView().getTreeViewer().refresh();
                PostponedAnomalyTabPropertySection.this.refresh();
            }

            public void focusGained(FocusEvent e) {
            }
        });
        UIUtils.addTabbedPropertiesTextResizeListener(this.fTitleText);
        CLabel titleLabel = widgetFactory.createCLabel(composite, "Title: ");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.fTitleText, -5);
        data.top = new FormAttachment((Control)this.fTitleText, 0, 0x1000000);
        titleLabel.setToolTipText("A Title that Identifies this Anomaly");
        titleLabel.setLayoutData((Object)data);
        this.fDescriptionText = widgetFactory.createText(composite, "", 2);
        data = new FormData();
        data.left = new FormAttachment(0, 150);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.fTitleText, 4);
        this.fDescriptionText.setLayoutData((Object)data);
        this.fDescriptionText.setToolTipText("A Detailed Description of the Anomaly");
        this.fDescriptionText.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                try {
                    if (!PostponedAnomalyTabPropertySection.this.fRefreshInProgress) {
                        String currentUser = R4EUIModelController.getReviewer();
                        R4EAnomaly modelAnomaly = ((R4EUIAnomalyBasic)PostponedAnomalyTabPropertySection.this.fProperties.getElement()).getAnomaly();
                        String newValue = PostponedAnomalyTabPropertySection.this.fDescriptionText.getText().trim();
                        if (!newValue.equals(modelAnomaly.getDescription()) && ((R4EUIPostponedAnomaly)PostponedAnomalyTabPropertySection.this.fProperties.getElement()).checkCompatibility()) {
                            Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)modelAnomaly, currentUser);
                            modelAnomaly.setDescription(PostponedAnomalyTabPropertySection.this.fDescriptionText.getText());
                            R4EUIModelController.FResourceUpdater.checkIn(bookNum);
                        }
                    }
                }
                catch (ResourceHandlingException e1) {
                    UIUtils.displayResourceErrorDialog(e1);
                }
                catch (OutOfSyncException e1) {
                    UIUtils.displaySyncErrorDialog(e1);
                }
                catch (CompatibilityException e1) {
                    UIUtils.displayCompatibilityErrorDialog(e1);
                }
                PostponedAnomalyTabPropertySection.this.refresh();
            }

            public void focusGained(FocusEvent e) {
            }
        });
        UIUtils.addTabbedPropertiesTextResizeListener(this.fDescriptionText);
        CLabel descriptionLabel = widgetFactory.createCLabel(composite, "Description: ");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.fDescriptionText, -5);
        data.top = new FormAttachment((Control)this.fDescriptionText, 0, 0x1000000);
        descriptionLabel.setToolTipText("A Detailed Description of the Anomaly");
        descriptionLabel.setLayoutData((Object)data);
        this.fStateCombo = widgetFactory.createCCombo(composite, 8);
        data = new FormData();
        data.left = new FormAttachment(0, 150);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.fDescriptionText, 4);
        this.fStateCombo.setToolTipText("The Current State of the Anomaly");
        this.fStateCombo.setVisibleItemCount(6);
        this.fStateCombo.setLayoutData((Object)data);
        this.fStateCombo.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                try {
                    R4EAnomalyState newState;
                    if (!PostponedAnomalyTabPropertySection.this.fRefreshInProgress && !(newState = R4EUIAnomalyExtended.getStateFromString(PostponedAnomalyTabPropertySection.this.fStateCombo.getText())).equals((Object)((R4EUIAnomalyBasic)PostponedAnomalyTabPropertySection.this.fProperties.getElement()).getAnomaly().getState()) && ((R4EUIPostponedAnomaly)PostponedAnomalyTabPropertySection.this.fProperties.getElement()).checkCompatibility()) {
                        if (newState.equals((Object)R4EAnomalyState.R4E_ANOMALY_STATE_REJECTED) && !((R4EUIAnomalyBasic)PostponedAnomalyTabPropertySection.this.fProperties.getElement()).getAnomaly().getState().equals((Object)R4EAnomalyState.R4E_ANOMALY_STATE_REJECTED)) {
                            boolean commentResult = ((R4EUIAnomalyBasic)PostponedAnomalyTabPropertySection.this.fProperties.getElement()).createComment(true);
                            if (commentResult) {
                                UIUtils.changeAnomalyState(PostponedAnomalyTabPropertySection.this.fProperties.getElement(), newState);
                                return;
                            }
                            final ErrorDialog dialog = new ErrorDialog(null, "R4E Error", "Cannot change Anomaly State", (IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.ui", 0, "Please enter a reason for rejecting this anomaly", null), 4);
                            Display.getDefault().syncExec(new Runnable(){

                                public void run() {
                                    dialog.open();
                                }
                            });
                            PostponedAnomalyTabPropertySection.this.refresh();
                            return;
                        }
                        UIUtils.changeAnomalyState(PostponedAnomalyTabPropertySection.this.fProperties.getElement(), newState);
                    }
                }
                catch (ResourceHandlingException e) {
                    UIUtils.displayResourceErrorDialog(e);
                }
                catch (CompatibilityException e1) {
                    UIUtils.displayCompatibilityErrorDialog(e1);
                }
                PostponedAnomalyTabPropertySection.this.refresh();
                R4EUIModelController.getNavigatorView().getTreeViewer().refresh();
            }
        });
        PostponedAnomalyTabPropertySection.addScrollListener(this.fStateCombo);
        this.fStateLabel = widgetFactory.createCLabel(composite, "State: ");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.fStateCombo, -5);
        data.top = new FormAttachment((Control)this.fStateCombo, 0, 0x1000000);
        this.fStateLabel.setToolTipText("The Current State of the Anomaly");
        this.fStateLabel.setLayoutData((Object)data);
        this.fAssignedToCombo = widgetFactory.createCCombo(composite, 8);
        data = new FormData();
        data.left = new FormAttachment(0, 150);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.fStateCombo, 4);
        this.fAssignedToCombo.setToolTipText("Participant assigned to Review this element.");
        this.fAssignedToCombo.setLayoutData((Object)data);
        this.fAssignedToCombo.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                try {
                    if (!PostponedAnomalyTabPropertySection.this.fRefreshInProgress) {
                        String currentUser = R4EUIModelController.getReviewer();
                        R4EAnomaly modelAnomaly = ((R4EUIAnomalyBasic)PostponedAnomalyTabPropertySection.this.fProperties.getElement()).getAnomaly();
                        String newValue = PostponedAnomalyTabPropertySection.this.fAssignedToCombo.getText().trim();
                        if (!modelAnomaly.getAssignedTo().contains((Object)newValue) && ((R4EUIPostponedAnomaly)PostponedAnomalyTabPropertySection.this.fProperties.getElement()).checkCompatibility()) {
                            R4EUIModelController.FResourceUpdater.checkOut((EObject)modelAnomaly, currentUser);
                            modelAnomaly.getAssignedTo().clear();
                            modelAnomaly.getAssignedTo().add((Object)newValue);
                        }
                    }
                }
                catch (ResourceHandlingException e1) {
                    UIUtils.displayResourceErrorDialog(e1);
                }
                catch (OutOfSyncException e1) {
                    UIUtils.displaySyncErrorDialog(e1);
                }
                catch (CompatibilityException e1) {
                    UIUtils.displayCompatibilityErrorDialog(e1);
                }
                R4EUIModelController.getNavigatorView().getTreeViewer().refresh();
                PostponedAnomalyTabPropertySection.this.refresh();
            }
        });
        PostponedAnomalyTabPropertySection.addScrollListener(this.fAssignedToCombo);
        CLabel assignedToLabel = widgetFactory.createCLabel(composite, "Assigned to: ");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.fAssignedToCombo, -5);
        data.top = new FormAttachment((Control)this.fAssignedToCombo, 0, 0x1000000);
        assignedToLabel.setToolTipText("Participant assigned to Review this element.");
        assignedToLabel.setLayoutData((Object)data);
        this.createParticipantDetailsSection(widgetFactory, composite, this.createAnomalyDetailsSection(widgetFactory, composite));
    }

    private Composite createAnomalyDetailsSection(TabbedPropertySheetWidgetFactory aWidgetFactory, final Composite aComposite) {
        ExpandableComposite anomalyDetailsSection = aWidgetFactory.createExpandableComposite(aComposite, 2);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.fAssignedToCombo, 4);
        anomalyDetailsSection.setLayoutData((Object)data);
        anomalyDetailsSection.setText(ANOMALY_DETAILS_SECTION_LABEL);
        anomalyDetailsSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                ScrolledComposite scrolledParent = (ScrolledComposite)aComposite.getParent().getParent().getParent().getParent().getParent();
                scrolledParent.setMinSize(aComposite.computeSize(-1, -1));
                scrolledParent.layout(true, true);
            }
        });
        anomalyDetailsSection.setLayout((Layout)new GridLayout(1, false));
        Composite anomalyDetailsSectionClient = aWidgetFactory.createComposite((Composite)anomalyDetailsSection);
        anomalyDetailsSectionClient.setLayoutData((Object)new GridData(4, 4, true, true));
        anomalyDetailsSectionClient.setLayout((Layout)new GridLayout(4, false));
        anomalyDetailsSection.setClient((Control)anomalyDetailsSectionClient);
        CLabel creationDateLabel = aWidgetFactory.createCLabel(anomalyDetailsSectionClient, "Creation Date: ");
        GridData gridData = new GridData(4, 0x1000000, false, false);
        gridData.horizontalSpan = 1;
        creationDateLabel.setToolTipText("The Creation Date for this Anomaly");
        creationDateLabel.setLayoutData((Object)gridData);
        aWidgetFactory.setBorderStyle(0);
        this.fCreationDateText = aWidgetFactory.createText(anomalyDetailsSectionClient, "", 0);
        gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = 3;
        this.fCreationDateText.setEditable(false);
        this.fCreationDateText.setToolTipText("The Creation Date for this Anomaly");
        this.fCreationDateText.setLayoutData((Object)gridData);
        CLabel positionLabel = aWidgetFactory.createCLabel(anomalyDetailsSectionClient, "Position: ");
        gridData = new GridData(4, 0x1000000, false, false);
        gridData.horizontalSpan = 1;
        positionLabel.setToolTipText("The Position in the Parent File of the Contents for this Anomaly");
        positionLabel.setLayoutData((Object)gridData);
        this.fPositionText = aWidgetFactory.createText(anomalyDetailsSectionClient, "", 0);
        gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = 3;
        this.fPositionText.setEditable(false);
        this.fPositionText.setToolTipText("The Position in the Parent File of the Contents for this Anomaly");
        this.fPositionText.setLayoutData((Object)gridData);
        CLabel classLabel = aWidgetFactory.createCLabel(anomalyDetailsSectionClient, "Class: ");
        gridData = new GridData(4, 0x1000000, false, false);
        gridData.horizontalSpan = 1;
        classLabel.setToolTipText("The Class of this Anomaly");
        classLabel.setLayoutData((Object)gridData);
        aWidgetFactory.setBorderStyle(2048);
        this.fClassCombo = aWidgetFactory.createCCombo(anomalyDetailsSectionClient, 8);
        gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = 3;
        this.fClassCombo.setToolTipText("The Class of this Anomaly");
        this.fClassCombo.setLayoutData((Object)gridData);
        this.fClassCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    if (!PostponedAnomalyTabPropertySection.this.fRefreshInProgress) {
                        String currentUser = R4EUIModelController.getReviewer();
                        R4EAnomaly modelAnomaly = ((R4EUIAnomalyBasic)PostponedAnomalyTabPropertySection.this.fProperties.getElement()).getAnomaly();
                        R4EDesignRuleClass newValue = UIUtils.getClassFromString(PostponedAnomalyTabPropertySection.this.fClassCombo.getText());
                        if ((modelAnomaly.getType() == null || !newValue.equals((Object)((R4ECommentType)modelAnomaly.getType()).getType())) && ((R4EUIPostponedAnomaly)PostponedAnomalyTabPropertySection.this.fProperties.getElement()).checkCompatibility()) {
                            Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)modelAnomaly, currentUser);
                            R4ECommentType type = Persistence.RModelFactoryExt.eINSTANCE.createR4ECommentType();
                            type.setType(newValue);
                            modelAnomaly.setType((CommentType)type);
                            R4EUIModelController.FResourceUpdater.checkIn(bookNum);
                        }
                    }
                }
                catch (ResourceHandlingException e1) {
                    UIUtils.displayResourceErrorDialog(e1);
                }
                catch (OutOfSyncException e1) {
                    UIUtils.displaySyncErrorDialog(e1);
                }
                catch (CompatibilityException e1) {
                    UIUtils.displayCompatibilityErrorDialog(e1);
                }
                PostponedAnomalyTabPropertySection.this.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        PostponedAnomalyTabPropertySection.addScrollListener(this.fClassCombo);
        CLabel rankLabel = aWidgetFactory.createCLabel(anomalyDetailsSectionClient, "Rank: ");
        gridData = new GridData(4, 0x1000000, false, false);
        gridData.horizontalSpan = 1;
        rankLabel.setToolTipText("The Rank (or Severity) of this Anomaly");
        rankLabel.setLayoutData((Object)gridData);
        this.fRankCombo = aWidgetFactory.createCCombo(anomalyDetailsSectionClient, 8);
        this.fRankCombo.setToolTipText("The Rank (or Severity) of this Anomaly");
        gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = 3;
        this.fRankCombo.setLayoutData((Object)gridData);
        this.fRankCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    if (!PostponedAnomalyTabPropertySection.this.fRefreshInProgress) {
                        String currentUser = R4EUIModelController.getReviewer();
                        R4EAnomaly modelAnomaly = ((R4EUIAnomalyBasic)PostponedAnomalyTabPropertySection.this.fProperties.getElement()).getAnomaly();
                        R4EDesignRuleRank newValue = UIUtils.getRankFromString(PostponedAnomalyTabPropertySection.this.fRankCombo.getText());
                        if (!newValue.equals((Object)modelAnomaly.getRank()) && ((R4EUIPostponedAnomaly)PostponedAnomalyTabPropertySection.this.fProperties.getElement()).checkCompatibility()) {
                            Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)modelAnomaly, currentUser);
                            modelAnomaly.setRank(newValue);
                            R4EUIModelController.FResourceUpdater.checkIn(bookNum);
                        }
                    }
                }
                catch (ResourceHandlingException e1) {
                    UIUtils.displayResourceErrorDialog(e1);
                }
                catch (OutOfSyncException e1) {
                    UIUtils.displaySyncErrorDialog(e1);
                }
                catch (CompatibilityException e1) {
                    UIUtils.displayCompatibilityErrorDialog(e1);
                }
                PostponedAnomalyTabPropertySection.this.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        PostponedAnomalyTabPropertySection.addScrollListener(this.fRankCombo);
        CLabel ruleIdLabel = aWidgetFactory.createCLabel(anomalyDetailsSectionClient, "Rule ID: ");
        gridData = new GridData(4, 0x1000000, false, false);
        gridData.horizontalSpan = 1;
        ruleIdLabel.setToolTipText("An Identifier for the Design Rule Violation reported by this Anomaly");
        ruleIdLabel.setLayoutData((Object)gridData);
        Composite ruleComposite = aWidgetFactory.createComposite(anomalyDetailsSectionClient);
        gridData = new GridData(4, 4, true, false);
        gridData.horizontalSpan = 3;
        ruleComposite.setToolTipText("An Identifier for the Design Rule Violation reported by this Anomaly");
        ruleComposite.setLayoutData((Object)gridData);
        ruleComposite.setLayout((Layout)new GridLayout(2, false));
        this.fRuleId = aWidgetFactory.createText(ruleComposite, "", 0);
        this.fRuleId.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fRuleId.setEditable(false);
        this.fRuleButton = aWidgetFactory.createButton(ruleComposite, "Update...", 0);
        this.fRuleButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.fRuleButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                R4EUIModelController.setJobInProgress(true);
                R4EAnomaly modelAnomaly = ((R4EUIAnomalyBasic)PostponedAnomalyTabPropertySection.this.fProperties.getElement()).getAnomaly();
                IAnomalyInputDialog dialog = R4EUIDialogFactory.getInstance().getNewAnomalyInputDialog();
                dialog.create();
                dialog.setTitle(modelAnomaly.getTitle());
                dialog.setDescription(modelAnomaly.getDescription());
                dialog.setDueDate(modelAnomaly.getDueDate());
                if (modelAnomaly.getAssignedTo().size() > 0) {
                    dialog.setAssigned((String)modelAnomaly.getAssignedTo().get(0));
                }
                if (modelAnomaly.getType() != null) {
                    dialog.setClass_(((R4ECommentType)modelAnomaly.getType()).getType());
                }
                dialog.setRank(modelAnomaly.getRank());
                dialog.setRuleID(modelAnomaly.getRuleID());
                int result = dialog.open();
                if (result == 0) {
                    try {
                        if (!PostponedAnomalyTabPropertySection.this.fRefreshInProgress && ((R4EUIPostponedAnomaly)PostponedAnomalyTabPropertySection.this.fProperties.getElement()).checkCompatibility()) {
                            String currentUser = R4EUIModelController.getReviewer();
                            Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)modelAnomaly, currentUser);
                            modelAnomaly.setTitle(dialog.getAnomalyTitleValue());
                            modelAnomaly.setDescription(dialog.getAnomalyDescriptionValue());
                            modelAnomaly.setDueDate(dialog.getDueDate());
                            modelAnomaly.getAssignedTo().clear();
                            modelAnomaly.getAssignedTo().add((Object)dialog.getAssigned());
                            if (dialog.getRuleReferenceValue() != null) {
                                R4EDesignRule rule = dialog.getRuleReferenceValue();
                                R4ECommentType commentType = RModelFactory.eINSTANCE.createR4ECommentType();
                                commentType.setType(rule.getClass_());
                                modelAnomaly.setType((CommentType)commentType);
                                modelAnomaly.setRank(rule.getRank());
                                modelAnomaly.setRuleID(rule.getId());
                            } else {
                                R4ECommentType commentType = RModelFactory.eINSTANCE.createR4ECommentType();
                                commentType.setType(dialog.getClass_());
                                modelAnomaly.setType((CommentType)commentType);
                                modelAnomaly.setRank(dialog.getRank());
                                modelAnomaly.setRuleID("");
                            }
                            R4EUIModelController.FResourceUpdater.checkIn(bookNum);
                            if (PostponedAnomalyTabPropertySection.this.fProperties.getElement() instanceof R4EUIAnomalyExtended) {
                                PostponedAnomalyTabPropertySection.this.fProperties.getElement().setName(R4EUIAnomalyExtended.buildAnomalyExtName(modelAnomaly, ((R4EUIAnomalyBasic)PostponedAnomalyTabPropertySection.this.fProperties.getElement()).getPosition()));
                            } else {
                                PostponedAnomalyTabPropertySection.this.fProperties.getElement().setName(R4EUIAnomalyBasic.buildAnomalyName(modelAnomaly, ((R4EUIAnomalyBasic)PostponedAnomalyTabPropertySection.this.fProperties.getElement()).getPosition()));
                            }
                        }
                    }
                    catch (ResourceHandlingException e1) {
                        UIUtils.displayResourceErrorDialog(e1);
                    }
                    catch (OutOfSyncException e1) {
                        UIUtils.displaySyncErrorDialog(e1);
                    }
                    catch (CompatibilityException e1) {
                        UIUtils.displayCompatibilityErrorDialog(e1);
                    }
                    PostponedAnomalyTabPropertySection.this.refresh();
                    R4EUIModelController.getNavigatorView().getTreeViewer().refresh();
                }
                R4EUIModelController.setJobInProgress(false);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        CLabel dateLabel = aWidgetFactory.createCLabel(anomalyDetailsSectionClient, "Due Date: ");
        gridData = new GridData(4, 0x1000000, false, false);
        gridData.horizontalSpan = 1;
        dateLabel.setLayoutData((Object)gridData);
        Composite dateComposite = aWidgetFactory.createComposite(anomalyDetailsSectionClient);
        gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 3;
        dateComposite.setToolTipText("The Target Date to Address this Anomaly");
        dateComposite.setLayoutData((Object)gridData);
        dateComposite.setLayout((Layout)new GridLayout(2, false));
        this.fDateText = aWidgetFactory.createText(dateComposite, "", 0);
        this.fDateText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fDateText.setEditable(false);
        this.fCalendarButton = aWidgetFactory.createButton(dateComposite, "...", 0);
        this.fCalendarButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.fCalendarButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                R4EUIModelController.setJobInProgress(true);
                ICalendarDialog dialog = R4EUIDialogFactory.getInstance().getCalendarDialog();
                int result = dialog.open();
                if (result == 0) {
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MMM-dd");
                    PostponedAnomalyTabPropertySection.this.fDateText.setText(dateFormat.format(dialog.getDate()));
                    try {
                        if (!PostponedAnomalyTabPropertySection.this.fRefreshInProgress) {
                            String currentUser = R4EUIModelController.getReviewer();
                            R4EAnomaly modelAnomaly = ((R4EUIAnomalyBasic)PostponedAnomalyTabPropertySection.this.fProperties.getElement()).getAnomaly();
                            Date newValue = dialog.getDate();
                            if (!newValue.equals(modelAnomaly.getDueDate()) && ((R4EUIPostponedAnomaly)PostponedAnomalyTabPropertySection.this.fProperties.getElement()).checkCompatibility()) {
                                Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)modelAnomaly, currentUser);
                                modelAnomaly.setDueDate(newValue);
                                R4EUIModelController.FResourceUpdater.checkIn(bookNum);
                            }
                        }
                    }
                    catch (ResourceHandlingException e1) {
                        UIUtils.displayResourceErrorDialog(e1);
                    }
                    catch (OutOfSyncException e1) {
                        UIUtils.displaySyncErrorDialog(e1);
                    }
                    catch (CompatibilityException e1) {
                        UIUtils.displayCompatibilityErrorDialog(e1);
                    }
                    PostponedAnomalyTabPropertySection.this.refresh();
                }
                R4EUIModelController.setJobInProgress(false);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return anomalyDetailsSection;
    }

    private void createParticipantDetailsSection(TabbedPropertySheetWidgetFactory aWidgetFactory, final Composite aComposite, Composite aTopComposite) {
        ExpandableComposite participantDetailsSection = aWidgetFactory.createExpandableComposite(aComposite, 2);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)aTopComposite, 4);
        participantDetailsSection.setLayoutData((Object)data);
        participantDetailsSection.setText(PARTICIPANT_DETAILS_SECTION_LABEL);
        participantDetailsSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                ScrolledComposite scrolledParent = (ScrolledComposite)aComposite.getParent().getParent().getParent().getParent().getParent();
                scrolledParent.setMinSize(aComposite.computeSize(-1, -1));
                scrolledParent.layout(true, true);
            }
        });
        participantDetailsSection.setLayout((Layout)new GridLayout(1, false));
        Composite participantDetailsSectionClient = aWidgetFactory.createComposite((Composite)participantDetailsSection);
        participantDetailsSectionClient.setLayoutData((Object)new GridData(4, 4, true, true));
        participantDetailsSectionClient.setLayout((Layout)new GridLayout(4, false));
        participantDetailsSection.setClient((Control)participantDetailsSectionClient);
        CLabel authorLabel = aWidgetFactory.createCLabel(participantDetailsSectionClient, "Added By: ");
        GridData gridData = new GridData(4, 0x1000000, false, false);
        gridData.horizontalSpan = 1;
        authorLabel.setToolTipText("The Id of the Participant that created this Anomaly");
        authorLabel.setLayoutData((Object)gridData);
        aWidgetFactory.setBorderStyle(0);
        this.fAuthorText = aWidgetFactory.createText(participantDetailsSectionClient, "", 0);
        gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = 3;
        this.fAuthorText.setEditable(false);
        this.fAuthorText.setToolTipText("The Id of the Participant that created this Anomaly");
        this.fAuthorText.setLayoutData((Object)gridData);
        aWidgetFactory.setBorderStyle(2048);
        this.fDecidedByLabel = aWidgetFactory.createCLabel(participantDetailsSectionClient, "Decided by: ");
        gridData = new GridData(4, 0x1000000, false, false);
        gridData.horizontalSpan = 1;
        this.fDecidedByLabel.setToolTipText("The Participant that Analyzed this reported Anomaly");
        this.fDecidedByLabel.setLayoutData((Object)gridData);
        this.fDecidedByCombo = aWidgetFactory.createCCombo(participantDetailsSectionClient, 8);
        gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = 3;
        this.fDecidedByCombo.setToolTipText("The Participant that Analyzed this reported Anomaly");
        this.fDecidedByCombo.setLayoutData((Object)gridData);
        this.fDecidedByCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    if (!PostponedAnomalyTabPropertySection.this.fRefreshInProgress) {
                        String currentUser = R4EUIModelController.getReviewer();
                        R4EAnomaly modelAnomaly = ((R4EUIAnomalyExtended)PostponedAnomalyTabPropertySection.this.fProperties.getElement()).getAnomaly();
                        String newValue = PostponedAnomalyTabPropertySection.this.fDecidedByCombo.getText();
                        if (!newValue.equals(modelAnomaly.getDecidedByID()) && ((R4EUIPostponedAnomaly)PostponedAnomalyTabPropertySection.this.fProperties.getElement()).checkCompatibility()) {
                            Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)modelAnomaly, currentUser);
                            modelAnomaly.setDecidedByID(newValue);
                            R4EUIModelController.FResourceUpdater.checkIn(bookNum);
                            ((R4EUIPostponedAnomaly)PostponedAnomalyTabPropertySection.this.fProperties.getElement()).updateOriginalAnomaly();
                        }
                    }
                }
                catch (ResourceHandlingException e1) {
                    UIUtils.displayResourceErrorDialog(e1);
                }
                catch (OutOfSyncException e1) {
                    UIUtils.displaySyncErrorDialog(e1);
                }
                catch (CompatibilityException e1) {
                    UIUtils.displayCompatibilityErrorDialog(e1);
                }
                PostponedAnomalyTabPropertySection.this.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        PostponedAnomalyTabPropertySection.addScrollListener(this.fDecidedByCombo);
        this.fFixedByLabel = aWidgetFactory.createCLabel(participantDetailsSectionClient, "Fixed by: ");
        gridData = new GridData(4, 0x1000000, false, false);
        gridData.horizontalSpan = 1;
        this.fFixedByLabel.setToolTipText("The Participant that Fixed the Issue Reported in this Anomaly");
        this.fFixedByLabel.setLayoutData((Object)gridData);
        this.fFixedByCombo = aWidgetFactory.createCCombo(participantDetailsSectionClient, 8);
        gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = 3;
        this.fFixedByCombo.setToolTipText("The Participant that Fixed the Issue Reported in this Anomaly");
        this.fFixedByCombo.setLayoutData((Object)gridData);
        this.fFixedByCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    if (!PostponedAnomalyTabPropertySection.this.fRefreshInProgress) {
                        String currentUser = R4EUIModelController.getReviewer();
                        R4EAnomaly modelAnomaly = ((R4EUIAnomalyExtended)PostponedAnomalyTabPropertySection.this.fProperties.getElement()).getAnomaly();
                        String newValue = PostponedAnomalyTabPropertySection.this.fFixedByCombo.getText();
                        if (!newValue.equals(modelAnomaly.getFixedByID()) && ((R4EUIPostponedAnomaly)PostponedAnomalyTabPropertySection.this.fProperties.getElement()).checkCompatibility()) {
                            Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)modelAnomaly, currentUser);
                            modelAnomaly.setFixedByID(newValue);
                            R4EUIModelController.FResourceUpdater.checkIn(bookNum);
                            ((R4EUIPostponedAnomaly)PostponedAnomalyTabPropertySection.this.fProperties.getElement()).updateOriginalAnomaly();
                        }
                    }
                }
                catch (ResourceHandlingException e1) {
                    UIUtils.displayResourceErrorDialog(e1);
                }
                catch (OutOfSyncException e1) {
                    UIUtils.displaySyncErrorDialog(e1);
                }
                catch (CompatibilityException e1) {
                    UIUtils.displayCompatibilityErrorDialog(e1);
                }
                PostponedAnomalyTabPropertySection.this.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        PostponedAnomalyTabPropertySection.addScrollListener(this.fFixedByCombo);
        this.fFollowUpByLabel = aWidgetFactory.createCLabel(participantDetailsSectionClient, "Follow-up by: ");
        gridData = new GridData(4, 0x1000000, false, false);
        gridData.horizontalSpan = 1;
        this.fFollowUpByLabel.setToolTipText("The Participant that Verified the Fix for the Issue Reported in this Anomaly");
        this.fFollowUpByLabel.setLayoutData((Object)gridData);
        this.fFollowUpByCombo = aWidgetFactory.createCCombo(participantDetailsSectionClient, 8);
        gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = 3;
        this.fFollowUpByCombo.setToolTipText("The Participant that Verified the Fix for the Issue Reported in this Anomaly");
        this.fFollowUpByCombo.setLayoutData((Object)gridData);
        this.fFollowUpByCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    if (!PostponedAnomalyTabPropertySection.this.fRefreshInProgress) {
                        String currentUser = R4EUIModelController.getReviewer();
                        R4EAnomaly modelAnomaly = ((R4EUIAnomalyExtended)PostponedAnomalyTabPropertySection.this.fProperties.getElement()).getAnomaly();
                        String newValue = PostponedAnomalyTabPropertySection.this.fFollowUpByCombo.getText();
                        if (!newValue.equals(modelAnomaly.getFollowUpByID()) && ((R4EUIPostponedAnomaly)PostponedAnomalyTabPropertySection.this.fProperties.getElement()).checkCompatibility()) {
                            Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)modelAnomaly, currentUser);
                            modelAnomaly.setFollowUpByID(newValue);
                            R4EUIModelController.FResourceUpdater.checkIn(bookNum);
                            ((R4EUIPostponedAnomaly)PostponedAnomalyTabPropertySection.this.fProperties.getElement()).updateOriginalAnomaly();
                        }
                    }
                }
                catch (ResourceHandlingException e1) {
                    UIUtils.displayResourceErrorDialog(e1);
                }
                catch (OutOfSyncException e1) {
                    UIUtils.displaySyncErrorDialog(e1);
                }
                catch (CompatibilityException e1) {
                    UIUtils.displayCompatibilityErrorDialog(e1);
                }
                PostponedAnomalyTabPropertySection.this.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        PostponedAnomalyTabPropertySection.addScrollListener(this.fFollowUpByCombo);
    }

    public void refresh() {
        this.fRefreshInProgress = true;
        R4EUIPostponedAnomaly uiModelAnomaly = (R4EUIPostponedAnomaly)this.fProperties.getElement();
        R4EAnomaly modelAnomaly = uiModelAnomaly.getAnomaly();
        String originalReview = uiModelAnomaly.getOriginalReviewName();
        if (originalReview != null) {
            this.fReviewNameText.setText(originalReview);
        } else {
            this.fReviewNameText.setText("");
        }
        this.fTitleText.setText(modelAnomaly.getTitle());
        this.fAuthorText.setText(modelAnomaly.getUser().getId());
        this.fCreationDateText.setText(modelAnomaly.getCreatedOn().toString());
        this.fPosition = ((R4EUIAnomalyBasic)this.fProperties.getElement()).getPosition();
        if (this.fPosition == null) {
            this.fPositionText.setText("(Global Review Anomaly)");
        } else {
            this.fPositionText.setText(this.fPosition.toString());
        }
        this.fDescriptionText.setText(modelAnomaly.getDescription());
        String[] participants = R4EUIModelController.getActiveReview().getParticipantIDs().toArray(new String[R4EUIModelController.getActiveReview().getParticipantIDs().size()]);
        this.fAssignedToCombo.removeAll();
        this.fAssignedToCombo.add("");
        String[] stringArray = participants;
        int n = participants.length;
        int n2 = 0;
        while (n2 < n) {
            String participant = stringArray[n2];
            this.fAssignedToCombo.add(participant);
            ++n2;
        }
        if (modelAnomaly.getAssignedTo().size() > 0 && modelAnomaly.getAssignedTo().get(0) != null) {
            this.fAssignedToCombo.setText((String)modelAnomaly.getAssignedTo().get(0));
        } else {
            this.fAssignedToCombo.setText("");
        }
        this.fClassCombo.setItems(UIUtils.getClasses());
        if (modelAnomaly.getType() != null && ((R4ECommentType)modelAnomaly.getType()).getType() != null) {
            this.fClassCombo.select(((R4ECommentType)modelAnomaly.getType()).getType().getValue());
        } else {
            this.fClassCombo.setText("");
        }
        this.fRankCombo.setItems(UIUtils.getRanks());
        int rankValue = modelAnomaly.getRank().getValue();
        this.fRankCombo.select(rankValue == 3 ? 1 : rankValue);
        if (modelAnomaly.getRuleID() != null) {
            this.fRuleId.setText(modelAnomaly.getRuleID());
        }
        if (modelAnomaly.getDueDate() != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MMM-dd");
            this.fDateText.setText(dateFormat.format(modelAnomaly.getDueDate()));
        } else {
            this.fDateText.setText("");
        }
        if (this.fProperties.getElement() instanceof R4EUIAnomalyExtended) {
            this.fStateCombo.setItems(uiModelAnomaly.getAvailableStates());
            this.fStateCombo.select(uiModelAnomaly.mapStateToIndex(modelAnomaly.getState()));
            if (R4EUIModelController.getActiveReview() != null) {
                this.fDecidedByCombo.setItems(participants);
                int selectPos = UIUtils.mapParticipantToIndex(modelAnomaly.getDecidedByID());
                if (selectPos != -1) {
                    this.fDecidedByCombo.select(selectPos);
                } else {
                    this.fDecidedByCombo.setText(modelAnomaly.getDecidedByID() != null ? modelAnomaly.getDecidedByID() : "");
                }
                this.fFixedByCombo.setItems(participants);
                selectPos = UIUtils.mapParticipantToIndex(modelAnomaly.getFixedByID());
                if (selectPos != -1) {
                    this.fFixedByCombo.select(selectPos);
                } else {
                    this.fFixedByCombo.setText(modelAnomaly.getFixedByID() != null ? modelAnomaly.getFixedByID() : "");
                }
                this.fFollowUpByCombo.setItems(participants);
                selectPos = UIUtils.mapParticipantToIndex(modelAnomaly.getFollowUpByID());
                if (selectPos != -1) {
                    this.fFollowUpByCombo.select(selectPos);
                } else {
                    this.fFollowUpByCombo.setText(modelAnomaly.getFollowUpByID() != null ? modelAnomaly.getFollowUpByID() : "");
                }
            }
        }
        this.setEnabledFields();
        this.fRefreshInProgress = false;
    }

    protected void setEnabledFields() {
        if (R4EUIModelController.isJobInProgress() || this.fProperties.getElement().isReadOnly() || R4EUIModelController.getActiveReview() == null || ((R4EReviewState)R4EUIModelController.getActiveReview().getReview().getState()).getState().equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_COMPLETED) || !this.fProperties.getElement().isEnabled()) {
            this.fReviewNameText.setForeground(UIUtils.DISABLED_FONT_COLOR);
            this.fTitleText.setForeground(UIUtils.DISABLED_FONT_COLOR);
            this.fTitleText.setEditable(false);
            this.fAuthorText.setForeground(UIUtils.DISABLED_FONT_COLOR);
            this.fCreationDateText.setForeground(UIUtils.DISABLED_FONT_COLOR);
            this.fPositionText.setForeground(UIUtils.DISABLED_FONT_COLOR);
            this.fDescriptionText.setForeground(UIUtils.DISABLED_FONT_COLOR);
            this.fDescriptionText.setEditable(false);
            this.fStateCombo.setEnabled(false);
            this.fClassCombo.setEnabled(false);
            this.fRankCombo.setEnabled(false);
            this.fDateText.setForeground(UIUtils.DISABLED_FONT_COLOR);
            this.fCalendarButton.setEnabled(false);
            this.fDecidedByCombo.setEnabled(false);
            this.fFixedByCombo.setEnabled(false);
            this.fFollowUpByCombo.setEnabled(false);
            this.fRuleButton.setEnabled(false);
            this.fRuleId.setForeground(UIUtils.DISABLED_FONT_COLOR);
            this.fAssignedToCombo.setEnabled(false);
            if (this.fProperties.getElement() instanceof R4EUIAnomalyExtended) {
                this.fStateLabel.setVisible(true);
                this.fStateCombo.setVisible(true);
                this.fDecidedByLabel.setVisible(true);
                this.fDecidedByCombo.setVisible(true);
                this.fFixedByLabel.setVisible(true);
                this.fFixedByCombo.setVisible(true);
                this.fFollowUpByLabel.setVisible(true);
                this.fFollowUpByCombo.setVisible(true);
            } else {
                this.fStateLabel.setVisible(false);
                this.fStateCombo.setVisible(false);
                this.fDecidedByLabel.setVisible(false);
                this.fDecidedByCombo.setVisible(false);
                this.fFixedByLabel.setVisible(false);
                this.fFixedByCombo.setVisible(false);
                this.fFollowUpByLabel.setVisible(false);
                this.fFollowUpByCombo.setVisible(false);
            }
        } else {
            this.fReviewNameText.setForeground(UIUtils.ENABLED_FONT_COLOR);
            this.fAuthorText.setForeground(UIUtils.ENABLED_FONT_COLOR);
            this.fCreationDateText.setForeground(UIUtils.ENABLED_FONT_COLOR);
            this.fPositionText.setForeground(UIUtils.ENABLED_FONT_COLOR);
            this.fDescriptionText.setForeground(UIUtils.ENABLED_FONT_COLOR);
            this.fDescriptionText.setEditable(true);
            this.fRuleButton.setEnabled(true);
            this.fRuleId.setForeground(UIUtils.ENABLED_FONT_COLOR);
            this.fAssignedToCombo.setEnabled(true);
            R4EUIAnomalyBasic uiAnomaly = (R4EUIAnomalyBasic)this.fProperties.getElement();
            if (uiAnomaly.isTitleEnabled()) {
                this.fTitleText.setForeground(UIUtils.ENABLED_FONT_COLOR);
                this.fTitleText.setEditable(true);
            } else {
                this.fTitleText.setForeground(UIUtils.DISABLED_FONT_COLOR);
                this.fTitleText.setEditable(false);
            }
            if (uiAnomaly.isDueDateEnabled()) {
                this.fDateText.setForeground(UIUtils.ENABLED_FONT_COLOR);
                this.fCalendarButton.setEnabled(true);
            } else {
                this.fDateText.setForeground(UIUtils.DISABLED_FONT_COLOR);
                this.fCalendarButton.setEnabled(false);
            }
            if (uiAnomaly.isClassEnabled()) {
                this.fClassCombo.setEnabled(true);
            } else {
                this.fClassCombo.setEnabled(false);
            }
            if (uiAnomaly.isRankEnabled()) {
                this.fRankCombo.setEnabled(true);
            } else {
                this.fRankCombo.setEnabled(false);
            }
            if (this.fProperties.getElement() instanceof R4EUIAnomalyExtended) {
                this.fStateLabel.setVisible(true);
                this.fStateCombo.setVisible(true);
                this.fStateCombo.setEnabled(true);
                this.fDecidedByLabel.setVisible(true);
                this.fDecidedByCombo.setVisible(true);
                if (((R4EUIAnomalyExtended)uiAnomaly).isDecidedByEnabled()) {
                    this.fDecidedByCombo.setEnabled(true);
                } else {
                    this.fDecidedByCombo.setEnabled(false);
                }
                this.fFixedByLabel.setVisible(true);
                this.fFixedByCombo.setVisible(true);
                if (((R4EUIAnomalyExtended)uiAnomaly).isFixedByEnabled()) {
                    this.fFixedByCombo.setEnabled(true);
                } else {
                    this.fFixedByCombo.setEnabled(false);
                }
                this.fFollowUpByLabel.setVisible(true);
                this.fFollowUpByCombo.setVisible(true);
                if (((R4EUIAnomalyExtended)uiAnomaly).isFollowUpByEnabled()) {
                    this.fFollowUpByCombo.setEnabled(true);
                } else {
                    this.fFollowUpByCombo.setEnabled(false);
                }
            } else {
                this.fStateLabel.setVisible(false);
                this.fStateCombo.setVisible(false);
                this.fDecidedByCombo.setEnabled(false);
                this.fFixedByCombo.setEnabled(false);
                this.fFollowUpByCombo.setEnabled(false);
                this.fDecidedByLabel.setVisible(false);
                this.fDecidedByCombo.setVisible(false);
                this.fFixedByLabel.setVisible(false);
                this.fFixedByCombo.setVisible(false);
                this.fFollowUpByLabel.setVisible(false);
                this.fFollowUpByCombo.setVisible(false);
            }
        }
    }
}

