/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.core;

import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.core.ISessionListener;

public class SessionListenerManager {
    private static CopyOnWriteArrayList<ISessionListener> listeners = new CopyOnWriteArrayList();

    public static void addListener(ISessionListener listener) {
        listeners.addIfAbsent(listener);
    }

    public static void removeListener(ISessionListener listener) {
        listeners.remove(listener);
    }

    public static void beginCommand(Command cmd) {
        for (ISessionListener l : listeners) {
            l.beginCommand(cmd);
        }
    }

    public static void endCommand(Command cmd, IStatus s) {
        for (ISessionListener l : listeners) {
            l.endCommand(cmd, s);
        }
    }
}

