/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.AST;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.DASH;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.shacl.AST.AllObjectsTarget;
import org.eclipse.rdf4j.sail.shacl.AST.AllSubjectsTarget;
import org.eclipse.rdf4j.sail.shacl.AST.Path;
import org.eclipse.rdf4j.sail.shacl.AST.PathPropertyShape;
import org.eclipse.rdf4j.sail.shacl.AST.PlanGenerator;
import org.eclipse.rdf4j.sail.shacl.AST.PlaneNodeWrapper;
import org.eclipse.rdf4j.sail.shacl.AST.PropertyShape;
import org.eclipse.rdf4j.sail.shacl.AST.QueryGenerator;
import org.eclipse.rdf4j.sail.shacl.AST.RequiresEvalutation;
import org.eclipse.rdf4j.sail.shacl.AST.ShaclProperties;
import org.eclipse.rdf4j.sail.shacl.AST.TargetClass;
import org.eclipse.rdf4j.sail.shacl.AST.TargetNode;
import org.eclipse.rdf4j.sail.shacl.AST.TargetObjectsOf;
import org.eclipse.rdf4j.sail.shacl.AST.TargetShape;
import org.eclipse.rdf4j.sail.shacl.AST.TargetSubjectsOf;
import org.eclipse.rdf4j.sail.shacl.ConnectionsGroup;
import org.eclipse.rdf4j.sail.shacl.RdfsSubClassOfReasoner;
import org.eclipse.rdf4j.sail.shacl.ShaclSail;
import org.eclipse.rdf4j.sail.shacl.Stats;
import org.eclipse.rdf4j.sail.shacl.planNodes.BufferedSplitter;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNodeProvider;
import org.eclipse.rdf4j.sail.shacl.planNodes.Select;
import org.eclipse.rdf4j.sail.shacl.planNodes.TrimTuple;
import org.eclipse.rdf4j.sail.shacl.planNodes.Unique;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeShape
implements PlanGenerator,
RequiresEvalutation,
QueryGenerator {
    private static final Logger logger = LoggerFactory.getLogger(NodeShape.class);
    final Resource id;
    private List<PathPropertyShape> propertyShapes = Collections.emptyList();
    private List<PathPropertyShape> nodeShapes = Collections.emptyList();

    public NodeShape(Resource id, ShaclSail shaclSail, SailRepositoryConnection connection, boolean deactivated) {
        this.id = id;
        if (!deactivated) {
            this.propertyShapes = PropertyShape.Factory.getPropertyShapes(id, connection, this, shaclSail);
            this.nodeShapes = PropertyShape.Factory.getPropertyShapesInner(connection, this, id, null, shaclSail);
        }
    }

    @Override
    public PlanNode getPlan(ConnectionsGroup connectionsGroup, boolean printPlans, PlanNodeProvider overrideTargetNode, boolean negateThisPlan, boolean negateSubPlans) {
        Select node = new Select(connectionsGroup.getBaseConnection(), this.getQuery("?a", "?c", null), "?a", "?c");
        return new Unique(new TrimTuple(node, 0, 1));
    }

    @Override
    public PlanNode getPlanAddedStatements(ConnectionsGroup connectionsGroup, PlaneNodeWrapper planeNodeWrapper) {
        assert (planeNodeWrapper == null);
        PlanNode node = connectionsGroup.getCachedNodeFor(new Select(connectionsGroup.getAddedStatements(), this.getQuery("?a", "?c", null), "?a", "?c"));
        return new Unique(new TrimTuple(node, 0, 1));
    }

    @Override
    public PlanNode getPlanRemovedStatements(ConnectionsGroup connectionsGroup, PlaneNodeWrapper planeNodeWrapper) {
        assert (planeNodeWrapper == null);
        PlanNode node = connectionsGroup.getCachedNodeFor(new Select(connectionsGroup.getRemovedStatements(), this.getQuery("?a", "?c", null), "?a", "?c"));
        return new Unique(new TrimTuple(node, 0, 1));
    }

    @Override
    public PlanNode getAllTargetsPlan(ConnectionsGroup connectionsGroup, boolean negated) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Path> getPaths() {
        throw new IllegalStateException();
    }

    public Stream<PlanNode> generatePlans(ConnectionsGroup connectionsGroup, NodeShape nodeShape, boolean printPlans, boolean validateEntireBaseSail) {
        SailConnection removedStatements;
        SailConnection addedStatements;
        PlanNodeProvider overrideTargetNodeBufferedSplitter;
        if (validateEntireBaseSail) {
            if (connectionsGroup.getTransactionSettings().isCacheSelectNodes()) {
                PlanNode overrideTargetNode = this.getPlan(connectionsGroup, printPlans, null, false, false);
                overrideTargetNodeBufferedSplitter = new BufferedSplitter(overrideTargetNode);
            } else {
                overrideTargetNodeBufferedSplitter = () -> this.getPlan(connectionsGroup, printPlans, null, false, false);
            }
            addedStatements = connectionsGroup.getBaseConnection();
            removedStatements = connectionsGroup.getBaseConnection();
        } else {
            overrideTargetNodeBufferedSplitter = null;
            addedStatements = connectionsGroup.getAddedStatements();
            removedStatements = connectionsGroup.getRemovedStatements();
        }
        Stream<PlanNode> propertyShapesPlans = this.convertToPlan(this.propertyShapes, connectionsGroup, nodeShape, printPlans, overrideTargetNodeBufferedSplitter, addedStatements, removedStatements);
        Stream<PlanNode> nodeShapesPlans = this.convertToPlan(this.nodeShapes, connectionsGroup, nodeShape, printPlans, overrideTargetNodeBufferedSplitter, addedStatements, removedStatements);
        return Stream.concat(propertyShapesPlans, nodeShapesPlans);
    }

    private Stream<PlanNode> convertToPlan(List<PathPropertyShape> propertyShapes, ConnectionsGroup connectionsGroup, NodeShape nodeShape, boolean printPlans, PlanNodeProvider overrideTargetNodeBufferedSplitter, SailConnection addedStatements, SailConnection removedStatements) {
        Stats stats = connectionsGroup.getStats();
        return propertyShapes.stream().filter(propertyShape -> propertyShape.requiresEvaluation(addedStatements, removedStatements, stats)).map(propertyShape -> propertyShape.getPlan(connectionsGroup, printPlans, overrideTargetNodeBufferedSplitter, false, false));
    }

    @Override
    public boolean requiresEvaluation(SailConnection addedStatements, SailConnection removedStatements, Stats stats) {
        return true;
    }

    @Override
    public String getQuery(String subjectVariable, String objectVariable, RdfsSubClassOfReasoner rdfsSubClassOfReasoner) {
        return subjectVariable + " ?fj42798yfhf2j4 " + objectVariable + " .";
    }

    public Resource getId() {
        return this.id;
    }

    protected String buildSparqlValidNodes(String targetVar) {
        if (!this.propertyShapes.isEmpty() && !this.nodeShapes.isEmpty()) {
            throw new UnsupportedOperationException("sh:targetShape don't support both nodeshapes and property shapes!");
        }
        if (!this.propertyShapes.isEmpty()) {
            return this.propertyShapes.stream().map(propertyShapes -> propertyShapes.buildSparqlValidNodes(targetVar)).reduce((a, b) -> a + "\n" + b).orElse("");
        }
        if (!this.nodeShapes.isEmpty()) {
            return this.nodeShapes.stream().map(propertyShapes -> propertyShapes.buildSparqlValidNodes(targetVar)).reduce((a, b) -> a + "\n" + b).orElse("");
        }
        return "";
    }

    protected Stream<StatementPattern> getStatementPatterns() {
        return Stream.concat(this.propertyShapes.stream().flatMap(PropertyShape::getStatementPatterns), this.nodeShapes.stream().flatMap(PropertyShape::getStatementPatterns));
    }

    public String toString() {
        return this.id.toString();
    }

    public PlanNode getTargetFilter(ConnectionsGroup connectionsGroup, PlanNode parent) {
        return parent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeShape nodeShape = (NodeShape)o;
        return this.id.equals(nodeShape.id) && this.propertyShapes.equals(nodeShape.propertyShapes) && this.nodeShapes.equals(nodeShape.nodeShapes);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.propertyShapes, this.nodeShapes);
    }

    public static class Factory {
        public static List<NodeShape> getShapes(SailRepositoryConnection connection, ShaclSail shaclSail) {
            try (Stream stream = connection.getStatements(null, RDF.TYPE, (Value)SHACL.NODE_SHAPE, new Resource[0]).stream();){
                List<NodeShape> list = stream.map(Statement::getSubject).flatMap(shapeId -> {
                    ArrayList<NodeShape> propertyShapes = new ArrayList<NodeShape>();
                    ShaclProperties shaclProperties = new ShaclProperties((Resource)shapeId, connection);
                    if (!shaclProperties.getTargetClass().isEmpty()) {
                        propertyShapes.add(new TargetClass((Resource)shapeId, shaclSail, connection, shaclProperties.isDeactivated(), shaclProperties.getTargetClass()));
                    }
                    if (!shaclProperties.getTargetNode().isEmpty()) {
                        propertyShapes.add(new TargetNode((Resource)shapeId, shaclSail, connection, shaclProperties.isDeactivated(), shaclProperties.getTargetNode()));
                    }
                    if (!shaclProperties.getTargetSubjectsOf().isEmpty()) {
                        propertyShapes.add(new TargetSubjectsOf((Resource)shapeId, shaclSail, connection, shaclProperties.isDeactivated(), shaclProperties.getTargetSubjectsOf()));
                    }
                    if (!shaclProperties.getTargetObjectsOf().isEmpty()) {
                        propertyShapes.add(new TargetObjectsOf((Resource)shapeId, shaclSail, connection, shaclProperties.isDeactivated(), shaclProperties.getTargetObjectsOf()));
                    }
                    if (shaclSail.isEclipseRdf4jShaclExtensions()) {
                        shaclProperties.getTargetShape().stream().map(targetShape -> new TargetShape((Resource)shapeId, shaclSail, connection, shaclProperties.isDeactivated(), (Resource)targetShape)).forEach(propertyShapes::add);
                    }
                    if (!shaclProperties.getTarget().isEmpty()) {
                        shaclProperties.getTarget().forEach(sparqlTarget -> {
                            if (shaclSail.isDashDataShapes() && connection.hasStatement(sparqlTarget, RDF.TYPE, (Value)DASH.AllObjectsTarget, true, new Resource[0])) {
                                propertyShapes.add(new AllObjectsTarget((Resource)shapeId, shaclSail, connection, shaclProperties.isDeactivated()));
                            }
                            if (shaclSail.isDashDataShapes() && connection.hasStatement(sparqlTarget, RDF.TYPE, (Value)DASH.AllSubjectsTarget, true, new Resource[0])) {
                                propertyShapes.add(new AllSubjectsTarget((Resource)shapeId, shaclSail, connection, shaclProperties.isDeactivated()));
                            }
                        });
                    }
                    if (shaclSail.isUndefinedTargetValidatesAllSubjects() && propertyShapes.isEmpty()) {
                        logger.info("isUndefinedTargetValidatesAllSubjects() is deprecated, please use .setDashDataShapes(true) and use the custom targets from http://datashapes.org/dash#AllSubjectsTarget");
                        propertyShapes.add(new NodeShape((Resource)shapeId, shaclSail, connection, shaclProperties.isDeactivated()));
                    }
                    return propertyShapes.stream();
                }).filter(Objects::nonNull).collect(Collectors.toList());
                return list;
            }
        }
    }
}

