/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.rdfxml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.rdf4j.common.net.ParsedIRI;
import org.eclipse.rdf4j.common.xml.XMLUtil;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.util.Literals;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.XSD;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.WriterConfig;
import org.eclipse.rdf4j.rio.helpers.AbstractRDFWriter;
import org.eclipse.rdf4j.rio.helpers.BasicParserSettings;
import org.eclipse.rdf4j.rio.helpers.BasicWriterSettings;
import org.eclipse.rdf4j.rio.helpers.XMLWriterSettings;

public class RDFXMLWriter
extends AbstractRDFWriter
implements RDFWriter {
    protected ParsedIRI baseIRI;
    protected Writer writer;
    protected String defaultNamespace;
    protected boolean headerWritten = false;
    protected Resource lastWrittenSubject = null;
    protected char quote = (char)34;
    protected boolean entityQuote = false;

    public RDFXMLWriter(OutputStream out) {
        this(out, null);
    }

    public RDFXMLWriter(OutputStream out, ParsedIRI baseIRI) {
        super(out);
        this.baseIRI = baseIRI;
        this.writer = new OutputStreamWriter(out, StandardCharsets.UTF_8);
        this.namespaceTable = new LinkedHashMap();
    }

    public RDFXMLWriter(Writer writer) {
        this(writer, null);
    }

    public RDFXMLWriter(Writer writer, ParsedIRI baseIRI) {
        this.baseIRI = baseIRI;
        this.writer = writer;
        this.namespaceTable = new LinkedHashMap();
    }

    @Override
    public RDFFormat getRDFFormat() {
        return RDFFormat.RDFXML;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeHeader() throws IOException {
        try {
            this.setNamespace("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
            WriterConfig writerConfig = this.getWriterConfig();
            this.quote = (char)(writerConfig.get(XMLWriterSettings.USE_SINGLE_QUOTES) != false ? 39 : 34);
            this.entityQuote = writerConfig.get(XMLWriterSettings.QUOTES_TO_ENTITIES_IN_TEXT);
            if (writerConfig.get(XMLWriterSettings.INCLUDE_XML_PI).booleanValue()) {
                String str = this.quote == '\"' ? "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" : "<?xml version='1.0' encoding='UTF-8'?>\n";
                this.writer.write(str);
            }
            if (writerConfig.get(XMLWriterSettings.INCLUDE_ROOT_RDF_TAG).booleanValue()) {
                this.writeStartOfStartTag("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "RDF");
                if (this.defaultNamespace != null) {
                    this.writeNewLine();
                    this.writeIndent();
                    this.writeQuotedAttribute("xmlns", this.defaultNamespace);
                }
                for (Map.Entry entry : this.namespaceTable.entrySet()) {
                    String name = (String)entry.getKey();
                    String prefix = (String)entry.getValue();
                    this.writeNewLine();
                    this.writeIndent();
                    this.writeQuotedAttribute("xmlns:" + prefix, name);
                }
                if (this.baseIRI != null && writerConfig.get(BasicWriterSettings.BASE_DIRECTIVE).booleanValue()) {
                    this.writeNewLine();
                    this.writeIndent();
                    this.writeQuotedAttribute("xml:base", this.baseIRI.toString());
                }
                this.writeEndOfStartTag();
            }
            this.writeNewLine();
        }
        finally {
            this.headerWritten = true;
        }
    }

    @Override
    public void endRDF() throws RDFHandlerException {
        this.checkWritingStarted();
        try {
            if (!this.headerWritten) {
                this.writeHeader();
            }
            this.flushPendingStatements();
            this.writeNewLine();
            if (this.getWriterConfig().get(XMLWriterSettings.INCLUDE_ROOT_RDF_TAG).booleanValue()) {
                this.writeEndTag("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "RDF");
            }
            this.writer.flush();
        }
        catch (IOException e) {
            throw new RDFHandlerException(e);
        }
    }

    @Override
    public void handleNamespace(String prefix, String name) {
        this.checkWritingStarted();
        this.setNamespace(prefix, name);
    }

    protected void setNamespace(String prefix, String name) {
        if (this.headerWritten) {
            return;
        }
        if (prefix.isEmpty()) {
            this.defaultNamespace = name;
            return;
        }
        if (this.namespaceTable.containsKey(name)) {
            return;
        }
        boolean isLegalPrefix = XMLUtil.isNCName(prefix);
        if (!isLegalPrefix || this.namespaceTable.containsValue(prefix)) {
            if (!isLegalPrefix) {
                prefix = "ns";
            }
            int number = 1;
            while (this.namespaceTable.containsValue(prefix + number)) {
                ++number;
            }
            prefix = prefix + number;
        }
        this.namespaceTable.put(name, prefix);
    }

    @Override
    protected void consumeStatement(Statement st) {
        Resource subj = st.getSubject();
        IRI pred = st.getPredicate();
        Value obj = st.getObject();
        String predString = pred.toString();
        int predSplitIdx = XMLUtil.findURISplitIndex(predString);
        if (predSplitIdx == -1) {
            throw new RDFHandlerException("Unable to create XML namespace-qualified name for predicate: " + predString);
        }
        String predNamespace = predString.substring(0, predSplitIdx);
        String predLocalName = predString.substring(predSplitIdx);
        try {
            if (!this.headerWritten) {
                this.writeHeader();
            }
            if (!subj.equals(this.lastWrittenSubject)) {
                this.flushPendingStatements();
                this.writeNewLine();
                this.writeStartOfStartTag("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "Description");
                if (subj instanceof BNode) {
                    BNode bNode = (BNode)subj;
                    this.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "nodeID", this.getValidNodeId(bNode));
                } else if (this.baseIRI != null) {
                    this.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "about", this.baseIRI.relativize(subj.stringValue()));
                } else {
                    IRI uri = (IRI)subj;
                    this.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "about", uri.toString());
                }
                this.writeEndOfStartTag();
                this.writeNewLine();
                this.lastWrittenSubject = subj;
            }
            this.writeIndent();
            this.writeStartOfStartTag(predNamespace, predLocalName);
            if (obj instanceof Resource) {
                Resource objRes = (Resource)obj;
                if (objRes instanceof BNode) {
                    BNode bNode = (BNode)objRes;
                    this.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "nodeID", this.getValidNodeId(bNode));
                } else if (this.baseIRI != null) {
                    this.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "resource", this.baseIRI.relativize(objRes.stringValue()));
                } else {
                    IRI uri = (IRI)objRes;
                    this.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "resource", uri.toString());
                }
                this.writeEndOfEmptyTag();
            } else if (obj instanceof Literal) {
                Literal objLit = (Literal)obj;
                boolean isXMLLiteral = false;
                if (Literals.isLanguageLiteral(objLit)) {
                    this.writeAttribute("xml:lang", objLit.getLanguage().get());
                } else {
                    IRI datatype = objLit.getDatatype();
                    isXMLLiteral = datatype.equals(RDF.XMLLITERAL);
                    if (isXMLLiteral) {
                        this.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "parseType", "Literal");
                    } else if (!datatype.equals(XSD.STRING)) {
                        this.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "datatype", datatype.toString());
                    }
                }
                this.writeEndOfStartTag();
                if (isXMLLiteral) {
                    this.writer.write(objLit.getLabel());
                } else {
                    this.writeCharacterData(objLit.getLabel());
                }
                this.writeEndTag(predNamespace, predLocalName);
            }
            this.writeNewLine();
        }
        catch (IOException e) {
            throw new RDFHandlerException(e);
        }
    }

    @Override
    public void handleComment(String comment) throws RDFHandlerException {
        this.checkWritingStarted();
        try {
            if (!this.headerWritten) {
                this.writeHeader();
            }
            this.flushPendingStatements();
            this.writer.write("<!-- ");
            this.writer.write(comment);
            this.writer.write(" -->");
            this.writeNewLine();
        }
        catch (IOException e) {
            throw new RDFHandlerException(e);
        }
    }

    protected void flushPendingStatements() throws IOException, RDFHandlerException {
        if (this.lastWrittenSubject != null) {
            this.writeEndTag("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "Description");
            this.writeNewLine();
            this.lastWrittenSubject = null;
        }
    }

    protected void writeStartOfStartTag(String namespace, String localName) throws IOException {
        if (namespace.equals(this.defaultNamespace)) {
            this.writer.write("<");
            this.writer.write(localName);
        } else {
            String prefix = (String)this.namespaceTable.get(namespace);
            if (prefix == null || !this.getWriterConfig().get(XMLWriterSettings.INCLUDE_ROOT_RDF_TAG).booleanValue()) {
                this.writer.write("<");
                this.writer.write(localName);
                this.writeQuotedAttribute(" xmlns", namespace);
            } else {
                this.writer.write("<");
                this.writer.write(prefix);
                this.writer.write(":");
                this.writer.write(localName);
            }
        }
    }

    protected void writeAttribute(String attName, String value) throws IOException {
        this.writeQuotedAttribute(" " + attName, value);
    }

    protected void writeAttribute(String namespace, String attName, String value) throws IOException, RDFHandlerException {
        String prefix = (String)this.namespaceTable.get(namespace);
        if (prefix == null) {
            throw new RDFHandlerException("No prefix has been declared for the namespace used in this attribute: " + namespace);
        }
        this.writeQuotedAttribute(" " + prefix + ":" + attName, value);
    }

    protected void writeQuotedAttribute(String attName, String value) throws IOException {
        String str = this.quote == '\"' ? XMLUtil.escapeDoubleQuotedAttValue(value) : XMLUtil.escapeSingleQuotedAttValue(value);
        this.writer.write(attName);
        this.writer.write("=");
        this.writer.write(this.quote);
        this.writer.write(str);
        this.writer.write(this.quote);
    }

    protected void writeEndOfStartTag() throws IOException {
        this.writer.write(">");
    }

    protected void writeEndOfEmptyTag() throws IOException {
        this.writer.write("/>");
    }

    protected void writeEndTag(String namespace, String localName) throws IOException {
        if (namespace.equals(this.defaultNamespace)) {
            this.writer.write("</");
            this.writer.write(localName);
            this.writer.write(">");
        } else {
            this.writer.write("</");
            String prefix = (String)this.namespaceTable.get(namespace);
            if (prefix != null) {
                this.writer.write(prefix);
                this.writer.write(":");
            }
            this.writer.write(localName);
            this.writer.write(">");
        }
    }

    protected void writeCharacterData(String chars) throws IOException {
        String str = !this.entityQuote ? XMLUtil.escapeCharacterData(chars) : (this.quote == '\"' ? XMLUtil.escapeDoubleQuotedAttValue(chars) : XMLUtil.escapeSingleQuotedAttValue(chars));
        this.writer.write(str);
    }

    protected void writeIndent() throws IOException {
        this.writer.write("\t");
    }

    protected void writeNewLine() throws IOException {
        this.writer.write("\n");
    }

    protected String getValidNodeId(BNode bNode) throws IOException {
        String validNodeId = bNode.getID();
        if (!XMLUtil.isNCName(validNodeId)) {
            StringBuilder builder = new StringBuilder();
            if (validNodeId.isEmpty()) {
                if (this.getWriterConfig().get(BasicParserSettings.PRESERVE_BNODE_IDS).booleanValue()) {
                    throw new IOException("Cannot consistently write blank nodes with empty internal identifiers");
                }
                builder.append("genid-hash-");
                builder.append(Integer.toHexString(System.identityHashCode(bNode)));
            } else {
                if (!XMLUtil.isNCNameStartChar(validNodeId.charAt(0))) {
                    builder.append("genid-start-");
                    builder.append(Integer.toHexString(validNodeId.charAt(0)));
                } else {
                    builder.append(validNodeId.charAt(0));
                }
                for (int i = 1; i < validNodeId.length(); ++i) {
                    if (XMLUtil.isNCNameChar(validNodeId.charAt(i))) {
                        builder.append(validNodeId.charAt(i));
                        continue;
                    }
                    builder.append(Integer.toHexString(validNodeId.charAt(i)));
                }
            }
            validNodeId = builder.toString();
        }
        return validNodeId;
    }
}

