/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.planNodes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.rdf4j.sail.shacl.planNodes.LogStatement;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationExecutionLogger {
    private static final Logger logger = LoggerFactory.getLogger(ValidationExecutionLogger.class);
    private List<LogStatement> list = new ArrayList<LogStatement>();
    private static boolean groupedLogging = true;

    void log(int depth, String name, Tuple tuple, PlanNode planNode, String id) {
        LogStatement logStatement = new LogStatement(depth, name, tuple, planNode, id);
        if (groupedLogging) {
            this.list.add(logStatement);
        } else {
            logger.info(logStatement.toString());
        }
    }

    public void flush() {
        if (this.list.isEmpty()) {
            return;
        }
        HashMap map = new HashMap();
        this.list.forEach(s -> {
            map.computeIfAbsent(s.getId(), ss -> new ArrayList());
            ((List)map.get(s.getId())).add(s);
        });
        HashSet<String> printed = new HashSet<String>();
        for (LogStatement logStatement : this.list) {
            if (printed.contains(logStatement.getId())) continue;
            printed.add(logStatement.getId());
            ((List)map.get(logStatement.getId())).stream().map(Object::toString).forEachOrdered(arg_0 -> ((Logger)logger).info(arg_0));
        }
    }
}

