/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.federation.optimizers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.algebra.Join;
import org.eclipse.rdf4j.query.algebra.LeftJoin;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryOptimizer;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.helpers.StatementPatternCollector;
import org.eclipse.rdf4j.sail.federation.algebra.NaryJoin;
import org.eclipse.rdf4j.sail.federation.optimizers.EvaluationStatistics;

public class QueryMultiJoinOptimizer
implements QueryOptimizer {
    protected final EvaluationStatistics statistics;

    public QueryMultiJoinOptimizer() {
        this(new EvaluationStatistics());
    }

    public QueryMultiJoinOptimizer(EvaluationStatistics statistics) {
        this.statistics = statistics;
    }

    public void optimize(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings) {
        tupleExpr.visit((QueryModelVisitor)new JoinVisitor());
    }

    protected class JoinVisitor
    extends AbstractQueryModelVisitor<RuntimeException> {
        private Set<String> boundVars = new HashSet<String>();

        protected JoinVisitor() {
        }

        public void meet(LeftJoin leftJoin) {
            leftJoin.getLeftArg().visit((QueryModelVisitor)this);
            Set<String> origBoundVars = this.boundVars;
            try {
                this.boundVars = new HashSet<String>(this.boundVars);
                this.boundVars.addAll(leftJoin.getLeftArg().getBindingNames());
                leftJoin.getRightArg().visit((QueryModelVisitor)this);
            }
            finally {
                this.boundVars = origBoundVars;
            }
        }

        public void meetOther(QueryModelNode node) throws RuntimeException {
            if (node instanceof NaryJoin) {
                this.meetJoin((NaryJoin)node);
            } else {
                super.meetOther(node);
            }
        }

        public void meet(Join node) throws RuntimeException {
            this.meetJoin((TupleExpr)node);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void meetJoin(TupleExpr node) {
            Set<String> origBoundVars = this.boundVars;
            try {
                this.boundVars = new HashSet<String>(this.boundVars);
                ArrayList<TupleExpr> joinArgs = this.getJoinArgs(node, new ArrayList());
                HashMap<TupleExpr, Double> cardinalityMap = new HashMap<TupleExpr, Double>();
                HashMap<TupleExpr, List<Var>> varsMap = new HashMap<TupleExpr, List<Var>>();
                for (TupleExpr tupleExpr : joinArgs) {
                    cardinalityMap.put(tupleExpr, QueryMultiJoinOptimizer.this.statistics.getCardinality(tupleExpr));
                    varsMap.put(tupleExpr, this.getStatementPatternVars(tupleExpr));
                }
                HashMap<Var, Integer> varFreqMap = new HashMap<Var, Integer>();
                for (List varList : varsMap.values()) {
                    this.getVarFreqMap(varList, varFreqMap);
                }
                ArrayList<TupleExpr> arrayList = new ArrayList<TupleExpr>(joinArgs.size());
                while (!joinArgs.isEmpty()) {
                    TupleExpr tupleExpr = this.selectNextTupleExpr(joinArgs, cardinalityMap, varsMap, varFreqMap, this.boundVars);
                    joinArgs.remove(tupleExpr);
                    arrayList.add(tupleExpr);
                    tupleExpr.visit((QueryModelVisitor)this);
                    this.boundVars.addAll(tupleExpr.getBindingNames());
                }
                NaryJoin replacement = new NaryJoin((List<TupleExpr>)arrayList);
                node.replaceWith((QueryModelNode)replacement);
            }
            finally {
                this.boundVars = origBoundVars;
            }
        }

        protected <L extends List<TupleExpr>> L getJoinArgs(TupleExpr tupleExpr, L joinArgs) {
            if (tupleExpr instanceof NaryJoin) {
                NaryJoin join = (NaryJoin)tupleExpr;
                for (TupleExpr arg : join.getArgs()) {
                    this.getJoinArgs(arg, joinArgs);
                }
            } else if (tupleExpr instanceof Join) {
                Join join = (Join)tupleExpr;
                this.getJoinArgs(join.getLeftArg(), joinArgs);
                this.getJoinArgs(join.getRightArg(), joinArgs);
            } else {
                joinArgs.add((TupleExpr)tupleExpr);
            }
            return joinArgs;
        }

        protected List<Var> getStatementPatternVars(TupleExpr tupleExpr) {
            List stPatterns = StatementPatternCollector.process((QueryModelNode)tupleExpr);
            ArrayList<Var> varList = new ArrayList<Var>(stPatterns.size() * 4);
            for (StatementPattern sp : stPatterns) {
                sp.getVars(varList);
            }
            return varList;
        }

        protected <M extends Map<Var, Integer>> M getVarFreqMap(List<Var> varList, M varFreqMap) {
            for (Var var : varList) {
                Integer freq = varFreqMap.get(var);
                freq = freq == null ? 1 : freq + 1;
                varFreqMap.put((Var)var, (Integer)freq);
            }
            return varFreqMap;
        }

        protected TupleExpr selectNextTupleExpr(List<TupleExpr> expressions, Map<TupleExpr, Double> cardinalityMap, Map<TupleExpr, List<Var>> varsMap, Map<Var, Integer> varFreqMap, Set<String> boundVars) {
            double lowestCost = Double.MAX_VALUE;
            TupleExpr result = null;
            for (TupleExpr tupleExpr : expressions) {
                double cost = this.getTupleExprCost(tupleExpr, cardinalityMap, varsMap, varFreqMap, boundVars);
                if (!(cost < lowestCost)) continue;
                lowestCost = cost;
                result = tupleExpr;
            }
            return result;
        }

        protected double getTupleExprCost(TupleExpr tupleExpr, Map<TupleExpr, Double> cardinalityMap, Map<TupleExpr, List<Var>> varsMap, Map<Var, Integer> varFreqMap, Set<String> boundVars) {
            double cost = cardinalityMap.get(tupleExpr);
            List<Var> vars = varsMap.get(tupleExpr);
            List<Var> unboundVars = this.getUnboundVars(vars);
            List<Var> constantVars = this.getConstantVars(vars);
            int nonConstantCount = vars.size() - constantVars.size();
            if (nonConstantCount > 0) {
                double exp = (double)unboundVars.size() / (double)nonConstantCount;
                cost = Math.pow(cost, exp);
            }
            if (unboundVars.isEmpty()) {
                if (nonConstantCount > 0) {
                    cost /= (double)nonConstantCount;
                }
            } else {
                int foreignVarFreq = this.getForeignVarFreq(unboundVars, varFreqMap);
                if (foreignVarFreq > 0) {
                    cost /= (double)foreignVarFreq;
                }
            }
            return cost;
        }

        protected List<Var> getConstantVars(Iterable<Var> vars) {
            ArrayList<Var> constantVars = new ArrayList<Var>();
            for (Var var : vars) {
                if (!var.hasValue()) continue;
                constantVars.add(var);
            }
            return constantVars;
        }

        protected List<Var> getUnboundVars(Iterable<Var> vars) {
            ArrayList<Var> unboundVars = new ArrayList<Var>();
            for (Var var : vars) {
                if (var.hasValue() || this.boundVars.contains(var.getName())) continue;
                unboundVars.add(var);
            }
            return unboundVars;
        }

        protected int getForeignVarFreq(List<Var> ownUnboundVars, Map<Var, Integer> varFreqMap) {
            int result = 0;
            HashMap ownFreqMap = this.getVarFreqMap(ownUnboundVars, new HashMap());
            for (Map.Entry entry : ownFreqMap.entrySet()) {
                Var var = (Var)entry.getKey();
                int ownFreq = (Integer)entry.getValue();
                result += varFreqMap.get(var) - ownFreq;
            }
            return result;
        }
    }
}

