/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.util;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.solr.common.util.ByteUtils;
import org.apache.solr.common.util.MurmurHash2;
import org.apache.solr.common.util.Utf8CharSequence;
import org.noggit.CharArr;

public class ByteArrayUtf8CharSequence
implements Utf8CharSequence {
    protected byte[] buf;
    protected int offset;
    protected int hashCode = Integer.MIN_VALUE;
    protected int length;
    protected volatile String utf16;
    public Function<ByteArrayUtf8CharSequence, String> stringProvider;

    public ByteArrayUtf8CharSequence(String utf16) {
        this.buf = new byte[Math.multiplyExact(utf16.length(), 3)];
        this.offset = 0;
        this.length = ByteUtils.UTF16toUTF8(utf16, 0, utf16.length(), this.buf, 0);
        if (this.buf.length > this.length) {
            byte[] copy = new byte[this.length];
            System.arraycopy(this.buf, 0, copy, 0, this.length);
            this.buf = copy;
        }
        assert (this.isValid());
    }

    public byte[] getBuf() {
        return this.buf;
    }

    public int offset() {
        return this.offset;
    }

    public ByteArrayUtf8CharSequence(byte[] buf, int offset, int length) {
        this.buf = buf;
        this.offset = offset;
        this.length = length;
    }

    @Override
    public byte byteAt(int idx) {
        if (idx >= this.length || idx < 0) {
            throw new ArrayIndexOutOfBoundsException("idx must be >=0 and < " + this.length);
        }
        return this.buf[this.offset + idx];
    }

    public String getStringOrNull() {
        return this.utf16;
    }

    @Override
    public int write(int start, byte[] buffer, int pos) {
        return ByteArrayUtf8CharSequence._writeBytes(this.buf, this.offset, this.length, start, buffer, pos);
    }

    static int _writeBytes(byte[] src, int srcOffset, int srcLength, int start, byte[] buffer, int pos) {
        if (srcOffset == -1 || start >= srcLength) {
            return -1;
        }
        int writableBytes = Math.min(srcLength - start, buffer.length - pos);
        System.arraycopy(src, srcOffset + start, buffer, pos, writableBytes);
        return writableBytes;
    }

    @Override
    public int size() {
        return this.length;
    }

    private ByteArrayUtf8CharSequence(byte[] buf, int offset, int length, String utf16, int hashCode) {
        this.buf = buf;
        this.offset = offset;
        this.length = length;
        this.utf16 = utf16;
        this.hashCode = hashCode;
    }

    public int hashCode() {
        if (this.hashCode == Integer.MIN_VALUE) {
            this.hashCode = MurmurHash2.hash32(this.buf, this.offset, this.length);
        }
        return this.hashCode;
    }

    @Override
    public int length() {
        return this._getStr().length();
    }

    public boolean equals(Object other) {
        if (other instanceof Utf8CharSequence) {
            if (this.size() != ((Utf8CharSequence)other).size()) {
                return false;
            }
            if (other instanceof ByteArrayUtf8CharSequence) {
                if (this.length != ((ByteArrayUtf8CharSequence)other).length) {
                    return false;
                }
                ByteArrayUtf8CharSequence that = (ByteArrayUtf8CharSequence)other;
                return ByteArrayUtf8CharSequence._equals(this.buf, this.offset, this.offset + this.length, that.buf, that.offset, that.offset + that.length);
            }
            return ByteArrayUtf8CharSequence.utf8Equals(this, (Utf8CharSequence)other);
        }
        return false;
    }

    public static boolean utf8Equals(Utf8CharSequence utf8_1, Utf8CharSequence utf8_2) {
        if (utf8_1.size() != utf8_2.size()) {
            return false;
        }
        for (int i = 0; i < utf8_1.size(); ++i) {
            if (utf8_1.byteAt(i) == utf8_2.byteAt(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public char charAt(int index) {
        return this._getStr().charAt(index);
    }

    private String _getStr() {
        String utf16 = this.utf16;
        if (utf16 == null) {
            if (this.stringProvider != null) {
                this.utf16 = utf16 = this.stringProvider.apply(this);
            } else {
                CharArr arr = new CharArr();
                ByteUtils.UTF8toUTF16(this.buf, this.offset, this.length, arr);
                this.utf16 = utf16 = arr.toString();
            }
        }
        return utf16;
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return new ByteArrayUtf8CharSequence(this._getStr().subSequence(start, end).toString());
    }

    public ByteArrayUtf8CharSequence clone() {
        return new ByteArrayUtf8CharSequence(this.buf, this.offset, this.length, this.utf16, this.hashCode);
    }

    public ByteArrayUtf8CharSequence deepCopy() {
        byte[] bytes = new byte[this.length];
        System.arraycopy(this.buf, this.offset, bytes, 0, this.length);
        return new ByteArrayUtf8CharSequence(bytes, 0, this.length, this.utf16, this.hashCode);
    }

    public static Map.Entry convertCharSeq(Map.Entry e) {
        if (e.getKey() instanceof Utf8CharSequence || e.getValue() instanceof Utf8CharSequence) {
            return new AbstractMap.SimpleEntry<Object, Object>(ByteArrayUtf8CharSequence.convertCharSeq(e.getKey()), ByteArrayUtf8CharSequence.convertCharSeq(e.getValue()));
        }
        return e;
    }

    public static Collection convertCharSeq(Collection vals) {
        if (vals == null) {
            return vals;
        }
        boolean needsCopy = false;
        for (Object o : vals) {
            if (!(o instanceof Utf8CharSequence)) continue;
            needsCopy = true;
            break;
        }
        if (needsCopy) {
            AbstractCollection copy = null;
            copy = vals instanceof Set ? new HashSet(vals.size()) : new ArrayList(vals.size());
            for (Object o : vals) {
                copy.add(ByteArrayUtf8CharSequence.convertCharSeq(o));
            }
            return copy;
        }
        return vals;
    }

    public static Object convertCharSeq(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Utf8CharSequence) {
            return ((Utf8CharSequence)o).toString();
        }
        if (o instanceof Collection) {
            return ByteArrayUtf8CharSequence.convertCharSeq((Collection)o);
        }
        return o;
    }

    private static void checkFromToIndex(int fromIndex, int toIndex, int length) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex " + fromIndex + " > toIndex " + toIndex);
        }
        if (fromIndex < 0 || toIndex > length) {
            throw new IndexOutOfBoundsException("Range [" + fromIndex + ", " + toIndex + ") out-of-bounds for length " + length);
        }
    }

    @Override
    public String toString() {
        return this._getStr();
    }

    public static boolean _equals(byte[] a, int aFromIndex, int aToIndex, byte[] b, int bFromIndex, int bToIndex) {
        ByteArrayUtf8CharSequence.checkFromToIndex(aFromIndex, aToIndex, a.length);
        ByteArrayUtf8CharSequence.checkFromToIndex(bFromIndex, bToIndex, b.length);
        int aLen = aToIndex - aFromIndex;
        int bLen = bToIndex - bFromIndex;
        if (aLen != bLen) {
            return false;
        }
        for (int i = 0; i < aLen; ++i) {
            if (a[i + aFromIndex] == b[i + bFromIndex]) continue;
            return false;
        }
        return true;
    }

    public ByteArrayUtf8CharSequence reset(byte[] bytes, int offset, int length, String str) {
        this.buf = bytes;
        this.offset = offset;
        this.length = length;
        this.utf16 = str;
        this.hashCode = Integer.MIN_VALUE;
        return this;
    }

    public boolean isValid() {
        if (this.buf == null) {
            throw new IllegalStateException("bytes is null");
        }
        if (this.length < 0) {
            throw new IllegalStateException("length is negative: " + this.length);
        }
        if (this.length > this.buf.length) {
            throw new IllegalStateException("length is out of bounds: " + this.length + ",bytes.length=" + this.buf.length);
        }
        if (this.offset < 0) {
            throw new IllegalStateException("offset is negative: " + this.offset);
        }
        if (this.offset > this.buf.length) {
            throw new IllegalStateException("offset out of bounds: " + this.offset + ",bytes.length=" + this.buf.length);
        }
        if (this.offset + this.length < 0) {
            throw new IllegalStateException("offset+length is negative: offset=" + this.offset + ",length=" + this.length);
        }
        if (this.offset + this.length > this.buf.length) {
            throw new IllegalStateException("offset+length out of bounds: offset=" + this.offset + ",length=" + this.length + ",bytes.length=" + this.buf.length);
        }
        return true;
    }
}

