/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.util;

import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.model.util.Literals;
import org.eclipse.rdf4j.model.vocabulary.XSD;
import org.eclipse.rdf4j.query.algebra.Compare;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;

public class QueryEvaluationUtil {
    public static boolean getEffectiveBooleanValue(Value value) throws ValueExprEvaluationException {
        if (value instanceof Literal) {
            Literal literal = (Literal)value;
            String label = literal.getLabel();
            IRI datatype = literal.getDatatype();
            if (datatype.equals((Object)XSD.STRING)) {
                return label.length() > 0;
            }
            if (datatype.equals((Object)XSD.BOOLEAN)) {
                return "true".equals(label) || "1".equals(label);
            }
            if (datatype.equals((Object)XSD.DECIMAL)) {
                try {
                    String normDec = XMLDatatypeUtil.normalizeDecimal((String)label);
                    return !normDec.equals("0.0");
                }
                catch (IllegalArgumentException e) {
                    return false;
                }
            }
            if (XMLDatatypeUtil.isIntegerDatatype((IRI)datatype)) {
                try {
                    String normInt = XMLDatatypeUtil.normalize((String)label, (IRI)datatype);
                    return !normInt.equals("0");
                }
                catch (IllegalArgumentException e) {
                    return false;
                }
            }
            if (XMLDatatypeUtil.isFloatingPointDatatype((IRI)datatype)) {
                try {
                    String normFP = XMLDatatypeUtil.normalize((String)label, (IRI)datatype);
                    return !normFP.equals("0.0E0") && !normFP.equals("NaN");
                }
                catch (IllegalArgumentException e) {
                    return false;
                }
            }
        }
        throw new ValueExprEvaluationException();
    }

    public static boolean compare(Value leftVal, Value rightVal, Compare.CompareOp operator) throws ValueExprEvaluationException {
        return QueryEvaluationUtil.compare(leftVal, rightVal, operator, true);
    }

    public static boolean compare(Value leftVal, Value rightVal, Compare.CompareOp operator, boolean strict) throws ValueExprEvaluationException {
        if (leftVal instanceof Literal && rightVal instanceof Literal) {
            return QueryEvaluationUtil.compareLiterals((Literal)leftVal, (Literal)rightVal, operator, strict);
        }
        switch (operator) {
            case EQ: {
                return QueryEvaluationUtil.valuesEqual(leftVal, rightVal);
            }
            case NE: {
                return !QueryEvaluationUtil.valuesEqual(leftVal, rightVal);
            }
        }
        throw new ValueExprEvaluationException("Only literals with compatible, ordered datatypes can be compared using <, <=, > and >= operators");
    }

    private static boolean valuesEqual(Value leftVal, Value rightVal) {
        return leftVal != null && rightVal != null && leftVal.equals(rightVal);
    }

    public static boolean compareLiterals(Literal leftLit, Literal rightLit, Compare.CompareOp operator) throws ValueExprEvaluationException {
        return QueryEvaluationUtil.compareLiterals(leftLit, rightLit, operator, true);
    }

    public static boolean compareLiterals(Literal leftLit, Literal rightLit, Compare.CompareOp operator, boolean strict) throws ValueExprEvaluationException {
        IRI leftDatatype = leftLit.getDatatype();
        IRI rightDatatype = rightLit.getDatatype();
        boolean leftLangLit = Literals.isLanguageLiteral((Literal)leftLit);
        boolean rightLangLit = Literals.isLanguageLiteral((Literal)rightLit);
        IRI commonDatatype = null;
        if (QueryEvaluationUtil.isSimpleLiteral(leftLit) && QueryEvaluationUtil.isSimpleLiteral(rightLit)) {
            commonDatatype = XSD.STRING;
        }
        Integer compareResult = null;
        if (QueryEvaluationUtil.isSimpleLiteral(leftLit) && QueryEvaluationUtil.isSimpleLiteral(rightLit)) {
            compareResult = leftLit.getLabel().compareTo(rightLit.getLabel());
        } else if (!leftLangLit && !rightLangLit || commonDatatype != null) {
            if (commonDatatype == null) {
                if (leftDatatype.equals((Object)rightDatatype)) {
                    commonDatatype = leftDatatype;
                } else if (XMLDatatypeUtil.isNumericDatatype((IRI)leftDatatype) && XMLDatatypeUtil.isNumericDatatype((IRI)rightDatatype)) {
                    commonDatatype = leftDatatype.equals((Object)XSD.DOUBLE) || rightDatatype.equals((Object)XSD.DOUBLE) ? XSD.DOUBLE : (leftDatatype.equals((Object)XSD.FLOAT) || rightDatatype.equals((Object)XSD.FLOAT) ? XSD.FLOAT : (leftDatatype.equals((Object)XSD.DECIMAL) || rightDatatype.equals((Object)XSD.DECIMAL) ? XSD.DECIMAL : XSD.INTEGER));
                } else if (!strict && XMLDatatypeUtil.isCalendarDatatype((IRI)leftDatatype) && XMLDatatypeUtil.isCalendarDatatype((IRI)rightDatatype)) {
                    commonDatatype = XSD.DATETIME;
                } else if (!strict && XMLDatatypeUtil.isDurationDatatype((IRI)leftDatatype) && XMLDatatypeUtil.isDurationDatatype((IRI)rightDatatype)) {
                    commonDatatype = XSD.DURATION;
                }
            }
            if (commonDatatype != null) {
                try {
                    Object right;
                    Object left;
                    if (commonDatatype.equals((Object)XSD.DOUBLE)) {
                        compareResult = Double.compare(leftLit.doubleValue(), rightLit.doubleValue());
                    } else if (commonDatatype.equals((Object)XSD.FLOAT)) {
                        compareResult = Float.compare(leftLit.floatValue(), rightLit.floatValue());
                    } else if (commonDatatype.equals((Object)XSD.DECIMAL)) {
                        compareResult = leftLit.decimalValue().compareTo(rightLit.decimalValue());
                    } else if (XMLDatatypeUtil.isIntegerDatatype((IRI)commonDatatype)) {
                        compareResult = leftLit.integerValue().compareTo(rightLit.integerValue());
                    } else if (commonDatatype.equals((Object)XSD.BOOLEAN)) {
                        Boolean leftBool = leftLit.booleanValue();
                        Boolean rightBool = rightLit.booleanValue();
                        compareResult = leftBool.compareTo(rightBool);
                    } else if (XMLDatatypeUtil.isCalendarDatatype((IRI)commonDatatype)) {
                        left = leftLit.calendarValue();
                        compareResult = ((XMLGregorianCalendar)left).compare((XMLGregorianCalendar)(right = rightLit.calendarValue()));
                        if (compareResult == 2) {
                            if (leftDatatype.equals((Object)XSD.DATETIME) && rightDatatype.equals((Object)XSD.DATETIME)) {
                                throw new ValueExprEvaluationException("Indeterminate result for date/time comparison");
                            }
                            compareResult = null;
                        }
                    } else if (!strict && XMLDatatypeUtil.isDurationDatatype((IRI)commonDatatype)) {
                        left = XMLDatatypeUtil.parseDuration((String)leftLit.getLabel());
                        compareResult = ((Duration)left).compare((Duration)(right = XMLDatatypeUtil.parseDuration((String)rightLit.getLabel())));
                        if (compareResult == 2) {
                            compareResult = null;
                        }
                    } else if (commonDatatype.equals((Object)XSD.STRING)) {
                        compareResult = leftLit.getLabel().compareTo(rightLit.getLabel());
                    }
                }
                catch (IllegalArgumentException e) {
                    if (leftLit.equals((Object)rightLit)) {
                        switch (operator) {
                            case EQ: {
                                return true;
                            }
                            case NE: {
                                return false;
                            }
                        }
                    }
                    throw new ValueExprEvaluationException(e);
                }
            }
        }
        if (compareResult != null) {
            switch (operator) {
                case LT: {
                    return compareResult < 0;
                }
                case LE: {
                    return compareResult <= 0;
                }
                case EQ: {
                    return compareResult == 0;
                }
                case NE: {
                    return compareResult != 0;
                }
                case GE: {
                    return compareResult >= 0;
                }
                case GT: {
                    return compareResult > 0;
                }
            }
            throw new IllegalArgumentException("Unknown operator: " + operator);
        }
        boolean literalsEqual = leftLit.equals((Object)rightLit);
        if (!literalsEqual) {
            if (!leftLangLit && !rightLangLit && QueryEvaluationUtil.isSupportedDatatype(leftDatatype) && QueryEvaluationUtil.isSupportedDatatype(rightDatatype)) {
                if (!XMLDatatypeUtil.isValidValue((String)leftLit.getLabel(), (IRI)leftDatatype)) {
                    throw new ValueExprEvaluationException("not a valid datatype value: " + leftLit);
                }
                if (!XMLDatatypeUtil.isValidValue((String)rightLit.getLabel(), (IRI)rightDatatype)) {
                    throw new ValueExprEvaluationException("not a valid datatype value: " + rightLit);
                }
                boolean leftString = leftDatatype.equals((Object)XSD.STRING);
                boolean rightString = rightDatatype.equals((Object)XSD.STRING);
                boolean leftNumeric = XMLDatatypeUtil.isNumericDatatype((IRI)leftDatatype);
                boolean rightNumeric = XMLDatatypeUtil.isNumericDatatype((IRI)rightDatatype);
                boolean leftDate = XMLDatatypeUtil.isCalendarDatatype((IRI)leftDatatype);
                boolean rightDate = XMLDatatypeUtil.isCalendarDatatype((IRI)rightDatatype);
                if (leftString != rightString) {
                    throw new ValueExprEvaluationException("Unable to compare strings with other supported types");
                }
                if (leftNumeric != rightNumeric) {
                    throw new ValueExprEvaluationException("Unable to compare numeric types with other supported types");
                }
                if (leftDate != rightDate) {
                    throw new ValueExprEvaluationException("Unable to compare date types with other supported types");
                }
            } else if (!leftLangLit && !rightLangLit) {
                throw new ValueExprEvaluationException("Unable to compare literals with unsupported types");
            }
        }
        switch (operator) {
            case EQ: {
                return literalsEqual;
            }
            case NE: {
                return !literalsEqual;
            }
            case LT: 
            case LE: 
            case GE: 
            case GT: {
                throw new ValueExprEvaluationException("Only literals with compatible, ordered datatypes can be compared using <, <=, > and >= operators");
            }
        }
        throw new IllegalArgumentException("Unknown operator: " + operator);
    }

    public static boolean isPlainLiteral(Value v) {
        if (v instanceof Literal) {
            Literal l = (Literal)v;
            return l.getDatatype().equals((Object)XSD.STRING);
        }
        return false;
    }

    public static boolean isSimpleLiteral(Value v) {
        if (v instanceof Literal) {
            return QueryEvaluationUtil.isSimpleLiteral((Literal)v);
        }
        return false;
    }

    public static boolean isSimpleLiteral(Literal l) {
        return !Literals.isLanguageLiteral((Literal)l) && l.getDatatype().equals((Object)XSD.STRING);
    }

    public static boolean isStringLiteral(Value v) {
        if (v instanceof Literal) {
            return QueryEvaluationUtil.isStringLiteral((Literal)v);
        }
        return false;
    }

    public static boolean compatibleArguments(Literal arg1, Literal arg2) {
        boolean arg1Language = Literals.isLanguageLiteral((Literal)arg1);
        boolean arg2Language = Literals.isLanguageLiteral((Literal)arg2);
        boolean arg1Simple = QueryEvaluationUtil.isSimpleLiteral(arg1);
        boolean arg2Simple = QueryEvaluationUtil.isSimpleLiteral(arg2);
        boolean compatible = arg1Simple && arg2Simple || arg1Language && arg2Language && arg1.getLanguage().equals(arg2.getLanguage()) || arg1Language && arg2Simple;
        return compatible;
    }

    public static boolean isStringLiteral(Literal l) {
        IRI datatype = l.getDatatype();
        return Literals.isLanguageLiteral((Literal)l) || datatype.equals((Object)XSD.STRING);
    }

    private static boolean isSupportedDatatype(IRI datatype) {
        return XSD.STRING.equals((Object)datatype) || XMLDatatypeUtil.isNumericDatatype((IRI)datatype) || XMLDatatypeUtil.isCalendarDatatype((IRI)datatype);
    }
}

