/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.planNodes;

import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.GlobalValidationExecutionLogging;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Tuple;
import org.eclipse.rdf4j.sail.shacl.planNodes.ValidationExecutionLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class LoggingCloseableIteration
implements CloseableIteration<Tuple, SailException> {
    private final ValidationExecutionLogger validationExecutionLogger;
    private PlanNode planNode;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public LoggingCloseableIteration(PlanNode planNode, ValidationExecutionLogger validationExecutionLogger) {
        this.planNode = planNode;
        this.validationExecutionLogger = validationExecutionLogger;
    }

    static String leadingSpace(PlanNode planNode) {
        return LoggingCloseableIteration.leadingSpace(planNode.depth());
    }

    static String leadingSpace(int depth) {
        StringBuilder builder = new StringBuilder();
        for (int i = depth; i > 0; --i) {
            builder.append("  ");
        }
        return builder.toString();
    }

    public final Tuple next() throws SailException {
        Tuple tuple = this.loggingNext();
        if (GlobalValidationExecutionLogging.loggingEnabled) {
            this.validationExecutionLogger.log(this.planNode.depth(), this.planNode.getClass().getSimpleName() + ".next()", tuple, this.planNode, this.planNode.getId());
        }
        return tuple;
    }

    public final boolean hasNext() throws SailException {
        return this.localHasNext();
    }

    abstract Tuple loggingNext() throws SailException;

    abstract boolean localHasNext() throws SailException;

    private String leadingSpace() {
        return LoggingCloseableIteration.leadingSpace(this.planNode);
    }
}

