/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.planNodes;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.planNodes.LoggingCloseableIteration;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Tuple;
import org.eclipse.rdf4j.sail.shacl.planNodes.ValidationExecutionLogger;

class OnlyNonUnique
extends LoggingCloseableIteration {
    private Tuple next;
    private Tuple previous;
    private Set<String> seenLanguages = new HashSet<String>();
    private CloseableIteration<Tuple, SailException> parentIterator;

    OnlyNonUnique(PlanNode parent, ValidationExecutionLogger validationExecutionLogger) {
        super(parent, validationExecutionLogger);
        this.parentIterator = parent.iterator();
    }

    private void calculateNext() {
        if (this.next != null) {
            return;
        }
        while (this.next == null && this.parentIterator.hasNext()) {
            this.next = (Tuple)this.parentIterator.next();
            if (this.previous != null && !this.previous.getLine().get(0).equals(this.next.getLine().get(0))) {
                this.seenLanguages = new HashSet<String>();
            }
            this.previous = this.next;
            Value value = this.next.getlist().get(1);
            if (value instanceof Literal) {
                Optional lang = ((Literal)value).getLanguage();
                if (!lang.isPresent()) {
                    this.next = null;
                    continue;
                }
                if (this.seenLanguages.contains(lang.get())) continue;
                this.seenLanguages.add((String)lang.get());
                this.next = null;
                continue;
            }
            this.next = null;
        }
    }

    public void close() throws SailException {
        this.parentIterator.close();
    }

    @Override
    boolean localHasNext() throws SailException {
        this.calculateNext();
        return this.next != null;
    }

    @Override
    Tuple loggingNext() throws SailException {
        this.calculateNext();
        Tuple temp = this.next;
        this.next = null;
        return temp;
    }

    public void remove() throws SailException {
    }
}

