/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.planNodes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.query.algebra.evaluation.util.ValueComparator;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.planNodes.IteratorData;
import org.eclipse.rdf4j.sail.shacl.planNodes.LoggingCloseableIteration;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Tuple;
import org.eclipse.rdf4j.sail.shacl.planNodes.ValidationExecutionLogger;

public class Sort
implements PlanNode {
    private final PlanNode parent;
    private boolean printed = false;
    private ValidationExecutionLogger validationExecutionLogger;

    public Sort(PlanNode parent) {
        this.parent = parent;
    }

    @Override
    public CloseableIteration<Tuple, SailException> iterator() {
        return new LoggingCloseableIteration(this, this.validationExecutionLogger){
            CloseableIteration<Tuple, SailException> iterator;
            List<Tuple> sortedTuples;
            Iterator<Tuple> sortedTuplesIterator;
            ValueComparator valueComparator;
            {
                this.iterator = Sort.this.parent.iterator();
                this.valueComparator = new ValueComparator();
            }

            public void close() throws SailException {
                this.iterator.close();
            }

            @Override
            boolean localHasNext() throws SailException {
                this.sortTuples();
                return this.sortedTuplesIterator.hasNext();
            }

            private void sortTuples() {
                if (this.sortedTuples == null) {
                    this.sortedTuples = new ArrayList<Tuple>();
                    boolean alreadySorted = true;
                    Tuple prev = null;
                    while (this.iterator.hasNext()) {
                        Tuple next = (Tuple)this.iterator.next();
                        this.sortedTuples.add(next);
                        if (prev != null && this.valueComparator.compare(prev.getLine().get(0), next.getLine().get(0)) > 0) {
                            alreadySorted = false;
                        }
                        prev = next;
                    }
                    if (!alreadySorted && this.sortedTuples.size() > 1) {
                        if (this.sortedTuples.size() > 8192) {
                            Tuple[] objects = this.sortedTuples.toArray(new Tuple[0]);
                            Arrays.parallelSort(objects, (a, b) -> this.valueComparator.compare(a.getLine().get(0), b.getLine().get(0)));
                            this.sortedTuples = Arrays.asList(objects);
                        } else {
                            this.sortedTuples.sort((a, b) -> this.valueComparator.compare(a.getLine().get(0), b.getLine().get(0)));
                        }
                    }
                    this.sortedTuplesIterator = this.sortedTuples.iterator();
                }
            }

            @Override
            Tuple loggingNext() throws SailException {
                this.sortTuples();
                return this.sortedTuplesIterator.next();
            }

            public void remove() throws SailException {
            }
        };
    }

    @Override
    public int depth() {
        return this.parent.depth() + 1;
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        if (this.printed) {
            return;
        }
        this.printed = true;
        stringBuilder.append(this.getId() + " [label=\"" + StringEscapeUtils.escapeJava((String)this.toString()) + "\"];").append("\n");
        stringBuilder.append(this.parent.getId() + " -> " + this.getId()).append("\n");
        this.parent.getPlanAsGraphvizDot(stringBuilder);
    }

    @Override
    public String getId() {
        return System.identityHashCode(this) + "";
    }

    public String toString() {
        return "Sort";
    }

    @Override
    public IteratorData getIteratorDataType() {
        return this.parent.getIteratorDataType();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Sort)) {
            return false;
        }
        Sort sort = (Sort)o;
        return this.parent.equals(sort.parent);
    }

    public int hashCode() {
        return Objects.hash(this.parent);
    }

    @Override
    public void receiveLogger(ValidationExecutionLogger validationExecutionLogger) {
        this.validationExecutionLogger = validationExecutionLogger;
        this.parent.receiveLogger(validationExecutionLogger);
    }
}

