/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.http.server.repository.transaction;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.rdf4j.IsolationLevel;
import org.eclipse.rdf4j.IsolationLevels;
import org.eclipse.rdf4j.common.transaction.TransactionSetting;
import org.eclipse.rdf4j.common.transaction.TransactionSettingRegistry;
import org.eclipse.rdf4j.common.webapp.views.SimpleResponseView;
import org.eclipse.rdf4j.http.server.ClientHTTPException;
import org.eclipse.rdf4j.http.server.ProtocolUtil;
import org.eclipse.rdf4j.http.server.ServerHTTPException;
import org.eclipse.rdf4j.http.server.repository.RepositoryInterceptor;
import org.eclipse.rdf4j.http.server.repository.transaction.ActiveTransactionRegistry;
import org.eclipse.rdf4j.http.server.repository.transaction.Transaction;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContextException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.AbstractController;

public class TransactionStartController
extends AbstractController {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public TransactionStartController() throws ApplicationContextException {
        this.setSupportedMethods(new String[]{"POST"});
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Repository repository = RepositoryInterceptor.getRepository(request);
        String reqMethod = request.getMethod();
        if (!"POST".equals(reqMethod)) {
            throw new ClientHTTPException(405, "Method not allowed: " + reqMethod);
        }
        this.logger.info("POST transaction start");
        ModelAndView result = this.startTransaction(repository, request, response);
        this.logger.info("transaction started");
        return result;
    }

    private ModelAndView startTransaction(Repository repository, HttpServletRequest request, HttpServletResponse response) throws IOException, ClientHTTPException, ServerHTTPException {
        ProtocolUtil.logRequestParameters(request);
        HashMap<String, Serializable> model = new HashMap<String, Serializable>();
        ArrayList transactionSettings = new ArrayList();
        IsolationLevel[] isolationLevel = new IsolationLevel[]{null};
        String isolationLevelString = request.getParameter("isolation-level");
        if (isolationLevelString != null) {
            IRI level = SimpleValueFactory.getInstance().createIRI(isolationLevelString);
            for (IsolationLevels standardLevel : IsolationLevels.values()) {
                if (!standardLevel.getURI().equals(level)) continue;
                isolationLevel[0] = standardLevel;
                break;
            }
        }
        request.getParameterMap().forEach((k, v) -> {
            if (k.startsWith("transaction-setting__")) {
                String settingsName = k.replace("transaction-setting__", "");
                if (settingsName.equals(IsolationLevels.NONE.getName())) {
                    isolationLevel[0] = IsolationLevels.valueOf(v[0]);
                    transactionSettings.add(isolationLevel[0]);
                } else {
                    TransactionSettingRegistry.getInstance().get(settingsName).flatMap(factory -> factory.getTransactionSetting(v[0])).ifPresent(transactionSettings::add);
                }
            }
        });
        Transaction txn = null;
        boolean allGood = false;
        try {
            txn = new Transaction(repository);
            if (transactionSettings.isEmpty()) {
                if (isolationLevel[0] == null) {
                    txn.begin(new TransactionSetting[0]);
                } else {
                    txn.begin(isolationLevel[0]);
                }
            } else {
                txn.begin(transactionSettings.toArray(new TransactionSetting[0]));
            }
            UUID txnId = txn.getID();
            model.put("sc", Integer.valueOf(201));
            StringBuffer txnURL = request.getRequestURL();
            txnURL.append("/" + txnId.toString());
            HashMap<String, String> customHeaders = new HashMap<String, String>();
            customHeaders.put("Location", txnURL.toString());
            model.put("headers", customHeaders);
            ModelAndView result = new ModelAndView((View)SimpleResponseView.getInstance(), model);
            ActiveTransactionRegistry.INSTANCE.register(txn);
            allGood = true;
            ModelAndView modelAndView = result;
            return modelAndView;
        }
        catch (InterruptedException | ExecutionException | RepositoryException e) {
            throw new ServerHTTPException("Transaction start error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (!allGood) {
                try {
                    txn.close();
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new ServerHTTPException("Transaction start error: " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

