/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.n3;

import java.io.OutputStream;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.eclipse.rdf4j.common.net.ParsedIRI;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.WriterConfig;
import org.eclipse.rdf4j.rio.turtle.TurtleWriter;

public class N3Writer
implements RDFWriter {
    private TurtleWriter ttlWriter;
    private WriterConfig writerConfig = new WriterConfig();

    public N3Writer(OutputStream out) {
        this(out, null);
    }

    public N3Writer(OutputStream out, ParsedIRI baseIRI) {
        this.ttlWriter = new TurtleWriter(out, baseIRI);
    }

    public N3Writer(Writer writer) {
        this(writer, null);
    }

    public N3Writer(Writer writer, ParsedIRI baseIRI) {
        this.ttlWriter = new TurtleWriter(writer, baseIRI);
    }

    @Override
    public RDFFormat getRDFFormat() {
        return RDFFormat.N3;
    }

    @Override
    public RDFWriter setWriterConfig(WriterConfig config) {
        this.writerConfig = config;
        return this;
    }

    @Override
    public WriterConfig getWriterConfig() {
        return this.writerConfig;
    }

    @Override
    public Collection<RioSetting<?>> getSupportedSettings() {
        return Collections.emptyList();
    }

    @Override
    public <T> RDFWriter set(RioSetting<T> setting, T value) {
        this.getWriterConfig().set((RioSetting)setting, (Object)value);
        return this;
    }

    @Override
    public void startRDF() throws RDFHandlerException {
        this.ttlWriter.startRDF();
    }

    @Override
    public void endRDF() throws RDFHandlerException {
        this.ttlWriter.endRDF();
    }

    @Override
    public void handleNamespace(String prefix, String name) throws RDFHandlerException {
        this.ttlWriter.handleNamespace(prefix, name);
    }

    @Override
    public void handleStatement(Statement st) throws RDFHandlerException {
        this.ttlWriter.handleStatement(st);
    }

    @Override
    public void handleComment(String comment) throws RDFHandlerException {
        this.ttlWriter.handleComment(comment);
    }

    @Override
    public Optional<OutputStream> getOutputStream() {
        return this.ttlWriter.getOutputStream();
    }
}

