/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.AST;

import java.util.Objects;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.sail.shacl.AST.AbstractSimplePropertyShape;
import org.eclipse.rdf4j.sail.shacl.AST.NodeShape;
import org.eclipse.rdf4j.sail.shacl.AST.PathPropertyShape;
import org.eclipse.rdf4j.sail.shacl.ConnectionsGroup;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.planNodes.EnrichWithShape;
import org.eclipse.rdf4j.sail.shacl.planNodes.LiteralComparatorFilter;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNodeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaxInclusivePropertyShape
extends AbstractSimplePropertyShape {
    private final Literal maxInclusive;
    private static final Logger logger = LoggerFactory.getLogger(MaxInclusivePropertyShape.class);

    MaxInclusivePropertyShape(Resource id, SailRepositoryConnection connection, NodeShape nodeShape, boolean deactivated, PathPropertyShape parent, Resource path, Literal maxInclusive) {
        super(id, connection, nodeShape, deactivated, parent, path);
        this.maxInclusive = maxInclusive;
    }

    @Override
    public PlanNode getPlan(ConnectionsGroup connectionsGroup, boolean printPlans, PlanNodeProvider overrideTargetNode, boolean negateThisPlan, boolean negateSubPlans) {
        if (this.deactivated) {
            return null;
        }
        assert (!negateSubPlans) : "There are no subplans!";
        PlanNode invalidValues = MaxInclusivePropertyShape.getGenericSingleObjectPlan(connectionsGroup, this.nodeShape, parent -> new LiteralComparatorFilter(parent, this.maxInclusive, value -> value >= 0), this, overrideTargetNode, negateThisPlan);
        if (printPlans) {
            String planAsGraphvizDot = this.getPlanAsGraphvizDot(invalidValues, connectionsGroup);
            logger.info(planAsGraphvizDot);
        }
        return new EnrichWithShape(invalidValues, this);
    }

    @Override
    public SourceConstraintComponent getSourceConstraintComponent() {
        return SourceConstraintComponent.MaxInclusiveConstraintComponent;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MaxInclusivePropertyShape that = (MaxInclusivePropertyShape)o;
        return this.maxInclusive.equals(that.maxInclusive);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.maxInclusive);
    }

    public String toString() {
        return "MaxInclusivePropertyShape{maxInclusive=" + this.maxInclusive + ", path=" + this.getPath() + ", id=" + this.id + '}';
    }
}

