/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.app.logging.base;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.rdf4j.common.app.AppConfiguration;
import org.eclipse.rdf4j.common.app.logging.LogConfiguration;
import org.eclipse.rdf4j.common.app.logging.base.LogConverterHandler;
import org.eclipse.rdf4j.common.app.util.ConfigurationUtil;

public abstract class AbstractLogConfiguration
implements LogConfiguration {
    private static final String LOGGING_CONFIG_FILE = "logging.properties";
    private static final String PACKAGES_SLF4J_KEY = "packages.slf4j";
    private static final String PACKAGES_JUL_KEY = "packages.jul";
    private File baseDir;
    private File confDir;
    private File loggingDir;
    private boolean debugLoggingEnabled = false;
    private Set<String> packages = new LinkedHashSet<String>();
    private AppConfiguration config;

    protected AbstractLogConfiguration() throws IOException {
        this.initBase();
    }

    @Override
    public void setBaseDir(File baseDir) throws IOException {
        this.baseDir = baseDir;
        this.confDir = new File(baseDir, "conf");
        this.loggingDir = new File(baseDir, "logs");
        if (!this.loggingDir.mkdirs() && !this.loggingDir.canWrite()) {
            throw new IOException("Unable to create logging directory " + this.loggingDir.getAbsolutePath());
        }
    }

    @Override
    public File getBaseDir() {
        return this.baseDir;
    }

    @Override
    public File getConfDir() {
        return this.confDir;
    }

    @Override
    public File getLoggingDir() {
        return this.loggingDir;
    }

    private void initBase() throws IOException {
        String julPackages;
        Properties loggingConfig = ConfigurationUtil.loadConfigurationProperties(LOGGING_CONFIG_FILE, null);
        String slf4jPackages = loggingConfig.getProperty(PACKAGES_SLF4J_KEY);
        if (slf4jPackages != null) {
            String[] slf4jPackageNames;
            for (String packageName : slf4jPackageNames = slf4jPackages.split(",")) {
                this.packages.add(packageName);
            }
        }
        if ((julPackages = loggingConfig.getProperty(PACKAGES_JUL_KEY)) != null) {
            String[] julPackageNames;
            for (String packageName : julPackageNames = julPackages.split(",")) {
                this.packages.add(packageName);
                Logger logger = Logger.getLogger(packageName.trim());
                logger.setUseParentHandlers(false);
                logger.setLevel(Level.ALL);
                logger.addHandler(new LogConverterHandler());
            }
        }
    }

    @Override
    public boolean isDebugLoggingEnabled() {
        return this.debugLoggingEnabled;
    }

    @Override
    public void setDebugLoggingEnabled(boolean debugLoggingEnabled) {
        this.debugLoggingEnabled = debugLoggingEnabled;
    }

    protected Set<String> getPackages() {
        return Collections.unmodifiableSet(this.packages);
    }

    @Override
    public AppConfiguration getAppConfiguration() {
        return this.config;
    }

    @Override
    public void setAppConfiguration(AppConfiguration config) {
        this.config = config;
    }
}

