/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.NodeKindConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.FilterPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;

public class NodeKindFilter
extends FilterPlanNode {
    private final NodeKindConstraintComponent.NodeKind nodeKind;

    public NodeKindFilter(PlanNode parent, NodeKindConstraintComponent.NodeKind nodeKind) {
        super(parent);
        this.nodeKind = nodeKind;
    }

    @Override
    boolean checkTuple(ValidationTuple t) {
        Value value = t.getValue();
        switch (this.nodeKind) {
            case IRI: {
                return value instanceof IRI;
            }
            case Literal: {
                return value instanceof Literal;
            }
            case BlankNode: {
                return value instanceof BNode;
            }
            case IRIOrLiteral: {
                return value instanceof IRI || value instanceof Literal;
            }
            case BlankNodeOrIRI: {
                return value instanceof BNode || value instanceof IRI;
            }
            case BlankNodeOrLiteral: {
                return value instanceof BNode || value instanceof Literal;
            }
        }
        throw new IllegalStateException("Unknown nodeKind");
    }

    @Override
    public String toString() {
        return "NodeKindFilter{nodeKind=" + (Object)((Object)this.nodeKind) + '}';
    }
}

