/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.Objects;
import java.util.function.Function;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.memory.MemoryStoreConnection;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.Formatter;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.LoggingCloseableIteration;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationExecutionLogger;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnorderedSelect
implements PlanNode {
    private static final Logger logger = LoggerFactory.getLogger(UnorderedSelect.class);
    private final SailConnection connection;
    private final Resource subject;
    private final IRI predicate;
    private final Value object;
    private final Function<Statement, ValidationTuple> mapper;
    private boolean printed = false;
    private ValidationExecutionLogger validationExecutionLogger;

    public UnorderedSelect(SailConnection connection, Resource subject, IRI predicate, Value object, Function<Statement, ValidationTuple> mapper) {
        this.connection = connection;
        this.subject = subject;
        this.predicate = predicate;
        this.object = object;
        this.mapper = mapper;
    }

    @Override
    public CloseableIteration<? extends ValidationTuple, SailException> iterator() {
        return new LoggingCloseableIteration(this, this.validationExecutionLogger){
            final CloseableIteration<? extends Statement, SailException> statements;
            {
                this.statements = UnorderedSelect.this.connection.getStatements(UnorderedSelect.this.subject, UnorderedSelect.this.predicate, UnorderedSelect.this.object, true, new Resource[0]);
            }

            @Override
            public void close() throws SailException {
                this.statements.close();
            }

            @Override
            boolean localHasNext() throws SailException {
                return this.statements.hasNext();
            }

            @Override
            ValidationTuple loggingNext() throws SailException {
                return (ValidationTuple)UnorderedSelect.this.mapper.apply(this.statements.next());
            }

            @Override
            public void remove() throws SailException {
            }
        };
    }

    @Override
    public int depth() {
        return 0;
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        if (this.printed) {
            return;
        }
        this.printed = true;
        stringBuilder.append(this.getId() + " [label=\"" + StringEscapeUtils.escapeJava((String)this.toString()) + "\"];").append("\n");
        if (this.connection instanceof MemoryStoreConnection) {
            stringBuilder.append(System.identityHashCode(((MemoryStoreConnection)this.connection).getSail()) + " -> " + this.getId()).append("\n");
        } else {
            stringBuilder.append(System.identityHashCode(this.connection) + " -> " + this.getId()).append("\n");
        }
    }

    @Override
    public String getId() {
        return System.identityHashCode(this) + "";
    }

    public String toString() {
        return "UnorderedSelect{subject=" + Formatter.prefix(this.subject) + ", predicate=" + Formatter.prefix(this.predicate) + ", object=" + Formatter.prefix(this.object) + '}';
    }

    @Override
    public void receiveLogger(ValidationExecutionLogger validationExecutionLogger) {
        this.validationExecutionLogger = validationExecutionLogger;
    }

    @Override
    public boolean producesSorted() {
        return false;
    }

    @Override
    public boolean requiresSorted() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnorderedSelect that = (UnorderedSelect)o;
        return this.connection.equals(that.connection) && Objects.equals(this.subject, that.subject) && Objects.equals(this.predicate, that.predicate) && Objects.equals(this.object, that.object) && this.mapper.equals(that.mapper);
    }

    public int hashCode() {
        return Objects.hash(this.connection, this.subject, this.predicate, this.object, this.mapper);
    }
}

