/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.HelperTool;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.AbstractConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.paths.Path;

public class ClosedConstraintComponent
extends AbstractConstraintComponent {
    private final List<Path> paths;
    private final List<IRI> ignoredProperties;

    public ClosedConstraintComponent(RepositoryConnection connection, List<Resource> property, Resource ignoredProperties) {
        this.paths = property.stream().flatMap(r -> connection.getStatements(r, SHACL.PATH, null, new Resource[0]).stream().map(Statement::getObject).map(o -> (Resource)o).map(path -> Path.buildPath(connection, path))).collect(Collectors.toList());
        this.ignoredProperties = ignoredProperties != null ? HelperTool.toList(connection, ignoredProperties, IRI.class) : Collections.emptyList();
    }

    public ClosedConstraintComponent(ClosedConstraintComponent closedConstraintComponent) {
        this.paths = closedConstraintComponent.paths;
        this.ignoredProperties = closedConstraintComponent.ignoredProperties;
    }

    @Override
    public void toModel(Resource subject, IRI predicate, Model model, Set<Resource> exported) {
        model.add(subject, SHACL.CLOSED, (Value)SimpleValueFactory.getInstance().createLiteral(true), new Resource[0]);
    }

    @Override
    public SourceConstraintComponent getConstraintComponent() {
        return SourceConstraintComponent.ClosedConstraintComponent;
    }

    @Override
    public ConstraintComponent deepClone() {
        return new ClosedConstraintComponent(this);
    }
}

