/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.FilterPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;

public class MinLengthFilter
extends FilterPlanNode {
    private final long minLength;

    public MinLengthFilter(PlanNode parent, long minLength) {
        super(parent);
        this.minLength = minLength;
    }

    @Override
    boolean checkTuple(ValidationTuple t) {
        Value literal = t.getValue();
        return (long)literal.stringValue().length() >= this.minLength;
    }

    @Override
    public String toString() {
        return "MinLengthFilter{minLength=" + this.minLength + '}';
    }
}

