/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.solr.client.solrj.impl.HttpClientBuilderFactory;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.client.solrj.impl.PreemptiveAuth;
import org.apache.solr.client.solrj.impl.SolrHttpClientBuilder;
import org.apache.solr.common.params.MapSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.StrUtils;

public class PreemptiveBasicAuthClientBuilderFactory
implements HttpClientBuilderFactory {
    public static final String SYS_PROP_HTTP_CLIENT_CONFIG = "solr.httpclient.config";
    public static final String SYS_PROP_BASIC_AUTH_CREDENTIALS = "basicauth";
    private static SolrParams defaultParams;
    private static PreemptiveAuth requestInterceptor;

    public static void setDefaultSolrParams(SolrParams params) {
        defaultParams = params;
    }

    @Override
    public void close() throws IOException {
        HttpClientUtil.removeRequestInterceptor(requestInterceptor);
    }

    @Override
    public SolrHttpClientBuilder getHttpClientBuilder(Optional<SolrHttpClientBuilder> builder) {
        return builder.isPresent() ? this.initHttpClientBuilder(builder.get()) : this.initHttpClientBuilder(SolrHttpClientBuilder.create());
    }

    private SolrHttpClientBuilder initHttpClientBuilder(SolrHttpClientBuilder builder) {
        final String basicAuthUser = defaultParams.get("httpBasicAuthUser");
        final String basicAuthPass = defaultParams.get("httpBasicAuthPassword");
        if (basicAuthUser == null || basicAuthPass == null) {
            throw new IllegalArgumentException("username & password must be specified with " + this.getClass().getName());
        }
        builder.setDefaultCredentialsProvider(new SolrHttpClientBuilder.CredentialsProviderProvider(){

            @Override
            public CredentialsProvider getCredentialsProvider() {
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(basicAuthUser, basicAuthPass));
                return credsProvider;
            }
        });
        HttpClientUtil.addRequestInterceptor(requestInterceptor);
        return builder;
    }

    static {
        requestInterceptor = new PreemptiveAuth((AuthScheme)new BasicScheme());
        String credentials = System.getProperty(SYS_PROP_BASIC_AUTH_CREDENTIALS);
        String configFile = System.getProperty(SYS_PROP_HTTP_CLIENT_CONFIG);
        if (credentials != null && configFile != null) {
            throw new RuntimeException("Basic authentication credentials passed via a configuration file as well as java system property. Please choose one mechanism!");
        }
        if (credentials != null) {
            List<String> ss = StrUtils.splitSmart(credentials, ':');
            if (ss.size() != 2) {
                throw new RuntimeException("Please provide 'basicauth' in the 'user:password' format");
            }
            Properties defaultProps = new Properties();
            defaultProps.setProperty("httpBasicAuthUser", ss.get(0));
            defaultProps.setProperty("httpBasicAuthPassword", ss.get(1));
            defaultParams = new MapSolrParams(new HashMap<Object, Object>(defaultProps));
        }
        if (configFile != null) {
            try {
                Properties defaultProps = new Properties();
                defaultProps.load(new InputStreamReader((InputStream)new FileInputStream(configFile), StandardCharsets.UTF_8));
                defaultParams = new MapSolrParams(new HashMap<Object, Object>(defaultProps));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to read the Http client config file", e);
            }
        }
    }
}

