/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.Arrays;
import java.util.Set;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.memory.MemoryStoreConnection;
import org.eclipse.rdf4j.sail.shacl.GlobalValidationExecutionLogging;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.Formatter;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.LoggingCloseableIteration;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeHelper;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationExecutionLogger;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;

public class ExternalPredicateObjectFilter
implements PlanNode {
    private final SailConnection connection;
    private final Set<Resource> filterOnObject;
    private final IRI filterOnPredicate;
    private final FilterOn filterOn;
    PlanNode parent;
    private final boolean returnMatching;
    private boolean printed = false;
    private ValidationExecutionLogger validationExecutionLogger;

    public ExternalPredicateObjectFilter(SailConnection connection, IRI filterOnPredicate, Set<Resource> filterOnObject, PlanNode parent, boolean returnMatching, FilterOn filterOn) {
        parent = PlanNodeHelper.handleSorting(this, parent);
        this.connection = connection;
        this.filterOnPredicate = filterOnPredicate;
        this.filterOnObject = filterOnObject;
        this.parent = parent;
        this.filterOn = filterOn;
        this.returnMatching = returnMatching;
    }

    @Override
    public CloseableIteration<? extends ValidationTuple, SailException> iterator() {
        return new LoggingCloseableIteration(this, this.validationExecutionLogger){
            ValidationTuple next;
            final CloseableIteration<? extends ValidationTuple, SailException> parentIterator;
            {
                this.next = null;
                this.parentIterator = ExternalPredicateObjectFilter.this.parent.iterator();
            }

            void calculateNext() {
                while (this.next == null && this.parentIterator.hasNext()) {
                    Value value;
                    ValidationTuple temp = (ValidationTuple)this.parentIterator.next();
                    switch (ExternalPredicateObjectFilter.this.filterOn) {
                        case value: {
                            value = temp.getValue();
                            break;
                        }
                        case activeTarget: {
                            value = temp.getActiveTarget();
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unknown filterOn: " + (Object)((Object)ExternalPredicateObjectFilter.this.filterOn));
                        }
                    }
                    Resource matchedType = this.isType(value);
                    if (ExternalPredicateObjectFilter.this.returnMatching) {
                        if (matchedType != null) {
                            this.next = temp;
                            continue;
                        }
                        if (!GlobalValidationExecutionLogging.loggingEnabled) continue;
                        ExternalPredicateObjectFilter.this.validationExecutionLogger.log(ExternalPredicateObjectFilter.this.depth(), ExternalPredicateObjectFilter.this.getClass().getSimpleName() + ":IgnoredAsTypeMismatch", temp, ExternalPredicateObjectFilter.this, ExternalPredicateObjectFilter.this.getId());
                        continue;
                    }
                    if (matchedType == null) {
                        this.next = temp;
                        continue;
                    }
                    if (!GlobalValidationExecutionLogging.loggingEnabled) continue;
                    ExternalPredicateObjectFilter.this.validationExecutionLogger.log(ExternalPredicateObjectFilter.this.depth(), ExternalPredicateObjectFilter.this.getClass().getSimpleName() + ":IgnoredAsTypeMismatch", temp, ExternalPredicateObjectFilter.this, ExternalPredicateObjectFilter.this.getId());
                }
            }

            private Resource isType(Value subject) {
                if (subject.isResource()) {
                    return ExternalPredicateObjectFilter.this.filterOnObject.stream().filter(type -> ExternalPredicateObjectFilter.this.connection.hasStatement((Resource)subject, ExternalPredicateObjectFilter.this.filterOnPredicate, (Value)type, true, new Resource[0])).findFirst().orElse(null);
                }
                return null;
            }

            @Override
            public void close() throws SailException {
                this.parentIterator.close();
            }

            @Override
            boolean localHasNext() throws SailException {
                this.calculateNext();
                return this.next != null;
            }

            @Override
            ValidationTuple loggingNext() throws SailException {
                this.calculateNext();
                ValidationTuple temp = this.next;
                this.next = null;
                return temp;
            }

            @Override
            public void remove() throws SailException {
            }
        };
    }

    @Override
    public int depth() {
        return this.parent.depth() + 1;
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        if (this.printed) {
            return;
        }
        this.printed = true;
        stringBuilder.append(this.getId() + " [label=\"" + StringEscapeUtils.escapeJava((String)this.toString()) + "\"];").append("\n");
        stringBuilder.append(this.parent.getId() + " -> " + this.getId()).append("\n");
        if (this.connection instanceof MemoryStoreConnection) {
            stringBuilder.append(System.identityHashCode(((MemoryStoreConnection)this.connection).getSail()) + " -> " + this.getId() + " [label=\"filter source\"]").append("\n");
        } else {
            stringBuilder.append(System.identityHashCode(this.connection) + " -> " + this.getId() + " [label=\"filter source\"]").append("\n");
        }
        this.parent.getPlanAsGraphvizDot(stringBuilder);
    }

    public String toString() {
        return "ExternalPredicateObjectFilter{, filterOnPredicate=" + this.filterOnPredicate + "filterOnObject=" + Arrays.toString(this.filterOnObject.stream().map(Formatter::prefix).toArray()) + '}';
    }

    @Override
    public String getId() {
        return System.identityHashCode(this) + "";
    }

    @Override
    public void receiveLogger(ValidationExecutionLogger validationExecutionLogger) {
        this.validationExecutionLogger = validationExecutionLogger;
        this.parent.receiveLogger(validationExecutionLogger);
    }

    @Override
    public boolean producesSorted() {
        return this.parent.producesSorted();
    }

    @Override
    public boolean requiresSorted() {
        return false;
    }

    public static enum FilterOn {
        activeTarget,
        value;

    }
}

