/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.spin.config;

import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.config.SailConfigException;
import org.eclipse.rdf4j.sail.config.SailFactory;
import org.eclipse.rdf4j.sail.config.SailImplConfig;
import org.eclipse.rdf4j.sail.spin.SpinSail;
import org.eclipse.rdf4j.sail.spin.config.SpinSailConfig;

public class SpinSailFactory
implements SailFactory {
    public static final String SAIL_TYPE = "openrdf:SpinSail";

    @Override
    public String getSailType() {
        return SAIL_TYPE;
    }

    @Override
    public SailImplConfig getConfig() {
        return new SpinSailConfig();
    }

    @Override
    public Sail getSail(SailImplConfig config) throws SailConfigException {
        if (!SAIL_TYPE.equals(config.getType())) {
            throw new SailConfigException("Invalid Sail type: " + config.getType());
        }
        SpinSail spinSail = new SpinSail();
        if (config instanceof SpinSailConfig) {
            spinSail.setAxiomClosureNeeded(((SpinSailConfig)config).isAxiomClosureNeeded());
            spinSail.setValidateConstraints(((SpinSailConfig)config).isValidateConstraints());
        }
        return spinSail;
    }
}

