/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.ArrayDeque;
import java.util.Queue;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.GlobalValidationExecutionLogging;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.MultiStreamPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PushablePlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationExecutionLogger;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferedPlanNode<T extends MultiStreamPlanNode & PlanNode>
implements PushablePlanNode {
    private final Logger logger = LoggerFactory.getLogger(BufferedPlanNode.class);
    private final T parent;
    private final String name;
    private final Queue<ValidationTuple> buffer = new ArrayDeque<ValidationTuple>();
    private boolean closed;
    private boolean printed;
    private ValidationExecutionLogger validationExecutionLogger;

    BufferedPlanNode(T parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    @Override
    public CloseableIteration<? extends ValidationTuple, SailException> iterator() {
        return new CloseableIteration<ValidationTuple, SailException>(){
            {
                BufferedPlanNode.this.parent.init();
            }

            public void close() throws SailException {
                BufferedPlanNode.this.closed = true;
                BufferedPlanNode.this.parent.close();
            }

            public boolean hasNext() throws SailException {
                this.calculateNext();
                return !BufferedPlanNode.this.buffer.isEmpty();
            }

            private void calculateNext() {
                boolean success;
                while (BufferedPlanNode.this.buffer.isEmpty() && (success = BufferedPlanNode.this.parent.incrementIterator())) {
                }
            }

            public ValidationTuple next() throws SailException {
                this.calculateNext();
                ValidationTuple tuple = (ValidationTuple)BufferedPlanNode.this.buffer.remove();
                if (GlobalValidationExecutionLogging.loggingEnabled) {
                    BufferedPlanNode.this.validationExecutionLogger.log(BufferedPlanNode.this.depth(), BufferedPlanNode.this.parent.getClass().getSimpleName() + ":Buffered:" + BufferedPlanNode.this.name + ".next()", tuple, (PlanNode)((Object)BufferedPlanNode.this.parent), BufferedPlanNode.this.getId());
                }
                return tuple;
            }

            public void remove() throws SailException {
            }
        };
    }

    @Override
    public int depth() {
        return ((PlanNode)this.parent).depth();
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        if (this.printed) {
            return;
        }
        this.printed = true;
        ((PlanNode)this.parent).getPlanAsGraphvizDot(stringBuilder);
        stringBuilder.append(this.getId() + " [label=\"" + StringEscapeUtils.escapeJava((String)this.toString()) + "\"];").append("\n");
    }

    @Override
    public String getId() {
        return System.identityHashCode(this) + "";
    }

    @Override
    public void push(ValidationTuple next) {
        this.buffer.add(next);
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    public String toString() {
        return "BufferedPlanNode";
    }

    @Override
    public void receiveLogger(ValidationExecutionLogger validationExecutionLogger) {
        if (this.validationExecutionLogger == null) {
            this.validationExecutionLogger = validationExecutionLogger;
            ((PlanNode)this.parent).receiveLogger(validationExecutionLogger);
        }
    }

    @Override
    public boolean producesSorted() {
        return ((PlanNode)this.parent).producesSorted();
    }

    @Override
    public boolean requiresSorted() {
        return ((PlanNode)this.parent).requiresSorted();
    }
}

