/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.algebra.evaluation.util.ValueComparator;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.results.ValidationResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationTuple {
    private static final Logger logger = LoggerFactory.getLogger(ValidationTuple.class);
    static ValueComparator valueComparator = new ValueComparator();
    private final Deque<Value> chain;
    private ConstraintComponent.Scope scope;
    private boolean propertyShapeScopeWithValue;
    Deque<ValidationResult> validationResults = new ArrayDeque<ValidationResult>();

    public ValidationTuple(ValidationTuple validationTuple) {
        this.chain = new ArrayDeque<Value>(validationTuple.chain);
        this.scope = validationTuple.scope;
        this.propertyShapeScopeWithValue = validationTuple.propertyShapeScopeWithValue;
        if (validationTuple.validationResults != null) {
            this.validationResults = new ArrayDeque<ValidationResult>(validationTuple.validationResults);
        }
    }

    public ValidationTuple(BindingSet bindingSet, String[] variables, ConstraintComponent.Scope scope, boolean hasValue) {
        this(bindingSet, Arrays.asList(variables), scope, hasValue);
    }

    public ValidationTuple(BindingSet bindingSet, List<String> variables, ConstraintComponent.Scope scope, boolean hasValue) {
        this.chain = new ArrayDeque<Value>();
        for (String variable : variables) {
            this.chain.addLast(bindingSet.getValue(variable));
        }
        this.scope = scope;
        this.propertyShapeScopeWithValue = hasValue;
    }

    public ValidationTuple(Deque<Value> targets, ConstraintComponent.Scope scope, boolean hasValue) {
        this.chain = targets;
        this.scope = scope;
        this.propertyShapeScopeWithValue = hasValue;
    }

    public ValidationTuple(Value a, Value c, ConstraintComponent.Scope scope, boolean hasValue) {
        this.chain = new ArrayDeque<Value>();
        this.chain.addLast(a);
        this.chain.addLast(c);
        this.scope = scope;
        this.propertyShapeScopeWithValue = hasValue;
    }

    public ValidationTuple(Value subject, ConstraintComponent.Scope scope, boolean hasValue) {
        this.chain = new ArrayDeque<Value>();
        this.chain.addLast(subject);
        this.scope = scope;
        this.propertyShapeScopeWithValue = hasValue;
    }

    public boolean sameTargetAs(ValidationTuple other) {
        Value current = this.getActiveTarget();
        Value currentRight = other.getActiveTarget();
        return current.equals(currentRight);
    }

    public boolean hasValue() {
        assert (this.scope != null);
        return this.propertyShapeScopeWithValue || this.scope == ConstraintComponent.Scope.nodeShape;
    }

    public Value getValue() {
        assert (this.scope != null);
        if (this.hasValue()) {
            return this.chain.peekLast();
        }
        return null;
    }

    public ConstraintComponent.Scope getScope() {
        return this.scope;
    }

    public void setScope(ConstraintComponent.Scope scope) {
        assert (this.scope == null);
        this.scope = scope;
    }

    public int compareTarget(ValidationTuple other) {
        Value left = this.getActiveTarget();
        Value right = other.getActiveTarget();
        return valueComparator.compare(left, right);
    }

    public Deque<ValidationResult> toValidationResult() {
        return this.validationResults;
    }

    public void addValidationResult(ValidationResult validationResult) {
        if (this.validationResults == null) {
            this.validationResults = new ArrayDeque<ValidationResult>();
        }
        this.validationResults.addFirst(validationResult);
    }

    public Value getActiveTarget() {
        assert (this.scope != null);
        if (!this.propertyShapeScopeWithValue || this.scope != ConstraintComponent.Scope.propertyShape) {
            return this.chain.getLast();
        }
        if (this.chain.size() < 2) {
            throw new AssertionError(this.chain.size());
        }
        Value value = this.chain.removeLast();
        Value last = this.chain.getLast();
        this.chain.addLast(value);
        return last;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValidationTuple that = (ValidationTuple)o;
        return this.propertyShapeScopeWithValue == that.propertyShapeScopeWithValue && Objects.equals(new ArrayList<Value>(this.chain), new ArrayList<Value>(that.chain)) && this.scope == that.scope;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{new ArrayList<Value>(this.chain), this.scope, this.propertyShapeScopeWithValue});
    }

    public String toString() {
        return "ValidationTuple{chain=" + Arrays.toString(this.chain.toArray()) + ", scope=" + (Object)((Object)this.scope) + ", propertyShapeScopeWithValue=" + this.propertyShapeScopeWithValue + '}';
    }

    public void shiftToNodeShape() {
        assert (this.scope == ConstraintComponent.Scope.propertyShape);
        if (this.propertyShapeScopeWithValue) {
            this.propertyShapeScopeWithValue = false;
            this.chain.removeLast();
        }
        this.scope = ConstraintComponent.Scope.nodeShape;
    }

    public void shiftToPropertyShapeScope() {
        assert (this.scope == ConstraintComponent.Scope.nodeShape);
        assert (this.chain.size() >= 2);
        this.scope = ConstraintComponent.Scope.propertyShape;
        this.propertyShapeScopeWithValue = true;
    }

    public int getFullChainSize() {
        return this.chain.size();
    }

    public Collection<Value> getTargetChain(boolean includePropertyShapeValues) {
        if (this.scope == ConstraintComponent.Scope.propertyShape && this.hasValue() && !includePropertyShapeValues) {
            return this.chain.stream().limit(this.chain.size() - 1).collect(Collectors.toList());
        }
        return new ArrayList<Value>(this.chain);
    }

    public void setValue(Value value) {
        if (this.scope == ConstraintComponent.Scope.propertyShape) {
            if (this.propertyShapeScopeWithValue) {
                this.chain.removeLast();
            }
            this.chain.addLast(value);
        } else {
            this.chain.removeLast();
            this.chain.addLast(value);
        }
        this.propertyShapeScopeWithValue = true;
    }

    public int compareValue(ValidationTuple other) {
        Value left = this.getValue();
        Value right = other.getValue();
        return valueComparator.compare(left, right);
    }

    public void trimToTarget() {
        if (this.scope == ConstraintComponent.Scope.propertyShape && this.propertyShapeScopeWithValue) {
            this.chain.removeLast();
            this.propertyShapeScopeWithValue = false;
        }
    }

    public void pop() {
        if (this.getScope() == ConstraintComponent.Scope.propertyShape) {
            if (this.hasValue()) {
                assert (this.chain.size() > 1) : "Attempting to pop chain will not leave any elements on the chain! " + this.toString();
                this.chain.removeLast();
            } else {
                this.propertyShapeScopeWithValue = true;
            }
        } else {
            assert (this.chain.size() > 1) : "Attempting to pop chain will not leave any elements on the chain! " + this.toString();
            this.chain.removeLast();
        }
    }
}

