/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.federation.evaluation;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.LookAheadIteration;
import org.eclipse.rdf4j.common.iteration.UnionIteration;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.Join;
import org.eclipse.rdf4j.query.algebra.LeftJoin;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.Union;
import org.eclipse.rdf4j.query.algebra.evaluation.TripleSource;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedServiceResolver;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.StrictEvaluationStrategy;
import org.eclipse.rdf4j.query.algebra.evaluation.iterator.BadlyDesignedLeftJoinIterator;
import org.eclipse.rdf4j.query.algebra.evaluation.iterator.HashJoinIteration;
import org.eclipse.rdf4j.query.algebra.helpers.TupleExprs;
import org.eclipse.rdf4j.repository.evaluation.RepositoryTripleSource;
import org.eclipse.rdf4j.sail.federation.algebra.NaryJoin;
import org.eclipse.rdf4j.sail.federation.algebra.OwnedTupleExpr;
import org.eclipse.rdf4j.sail.federation.evaluation.ParallelJoinCursor;
import org.eclipse.rdf4j.sail.federation.evaluation.ParallelLeftJoinCursor;

public class FederationStrategy
extends StrictEvaluationStrategy {
    private final Executor executor;

    public FederationStrategy(Executor executor, TripleSource tripleSource, Dataset dataset, FederatedServiceResolver serviceManager) {
        super(tripleSource, dataset, serviceManager);
        this.executor = executor;
    }

    @Override
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(TupleExpr expr, BindingSet bindings) throws QueryEvaluationException {
        CloseableIteration<BindingSet, QueryEvaluationException> result = expr instanceof NaryJoin ? this.evaluate((NaryJoin)expr, bindings) : (expr instanceof OwnedTupleExpr ? this.evaluate((OwnedTupleExpr)expr, bindings) : super.evaluate(expr, bindings));
        return result;
    }

    @Override
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Join join, BindingSet bindings) throws QueryEvaluationException {
        ParallelJoinCursor result = this.evaluate(join.getLeftArg(), bindings);
        int n = 2;
        for (int i = 1; i < n; ++i) {
            result = new ParallelJoinCursor(this, result, join.getRightArg());
            this.executor.execute(result);
        }
        return result;
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(NaryJoin join, BindingSet bindings) throws QueryEvaluationException {
        assert (join.getNumberOfArguments() > 0);
        LookAheadIteration result = this.evaluate((TupleExpr)join.getArg(0), bindings);
        HashSet<String> collectedBindingNames = new HashSet<String>();
        collectedBindingNames.addAll(((TupleExpr)join.getArg(0)).getBindingNames());
        int n = join.getNumberOfArguments();
        for (int i = 1; i < n; ++i) {
            TupleExpr rightArg = (TupleExpr)join.getArg(i);
            if (TupleExprs.containsSubquery(rightArg) || rightArg instanceof OwnedTupleExpr && ((OwnedTupleExpr)rightArg).hasQuery()) {
                TupleExpr leftArg = (TupleExpr)join.getArg(i - 1);
                collectedBindingNames.addAll(leftArg.getBindingNames());
                result = new HashJoinIteration(this, result, collectedBindingNames, this.evaluate(rightArg, bindings), rightArg.getBindingNames(), false);
                continue;
            }
            result = new ParallelJoinCursor(this, result, (TupleExpr)join.getArg(i));
            this.executor.execute((Runnable)((Object)result));
            collectedBindingNames.addAll(rightArg.getBindingNames());
        }
        return result;
    }

    @Override
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(LeftJoin leftJoin, BindingSet bindings) throws QueryEvaluationException {
        LookAheadIteration result;
        Set<String> boundVars = bindings.getBindingNames();
        Set<String> leftVars = leftJoin.getLeftArg().getBindingNames();
        Set<String> optionalVars = leftJoin.getRightArg().getBindingNames();
        HashSet<String> problemVars = new HashSet<String>(boundVars);
        problemVars.retainAll(optionalVars);
        problemVars.removeAll(leftVars);
        if (problemVars.isEmpty()) {
            result = new ParallelLeftJoinCursor(this, leftJoin, bindings);
            this.executor.execute((Runnable)((Object)result));
        } else {
            result = new BadlyDesignedLeftJoinIterator(this, leftJoin, bindings, problemVars);
        }
        return result;
    }

    @Override
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Union union, BindingSet bindings) throws QueryEvaluationException {
        CloseableIteration[] iters = new CloseableIteration[]{this.evaluate(union.getLeftArg(), bindings), this.evaluate(union.getRightArg(), bindings)};
        return new UnionIteration<BindingSet, QueryEvaluationException>(iters);
    }

    private CloseableIteration<BindingSet, QueryEvaluationException> evaluate(OwnedTupleExpr expr, BindingSet bindings) throws QueryEvaluationException {
        CloseableIteration<BindingSet, QueryEvaluationException> result = expr.evaluate(this.dataset, bindings);
        if (result == null) {
            RepositoryTripleSource source = new RepositoryTripleSource(expr.getOwner());
            FederationStrategy eval = new FederationStrategy(this.executor, source, this.dataset, this.serviceResolver);
            result = eval.evaluate(expr.getArg(), bindings);
        }
        return result;
    }
}

