/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.evaluation;

import org.eclipse.rdf4j.federated.FederationContext;
import org.eclipse.rdf4j.federated.FederationManager;
import org.eclipse.rdf4j.federated.evaluation.FederationEvalStrategy;

public class FederationEvaluationStrategyFactory {
    public static FederationEvalStrategy getEvaluationStrategy(FederationManager.FederationType federationType, FederationContext federationContext) {
        switch (federationType) {
            case LOCAL: {
                return FederationEvaluationStrategyFactory.instantiate(federationContext.getConfig().getSailEvaluationStrategy(), federationContext);
            }
        }
        return FederationEvaluationStrategyFactory.instantiate(federationContext.getConfig().getSPARQLEvaluationStrategy(), federationContext);
    }

    private static FederationEvalStrategy instantiate(Class<? extends FederationEvalStrategy> evalStrategyClass, FederationContext federationContext) {
        try {
            return evalStrategyClass.getDeclaredConstructor(FederationContext.class).newInstance(federationContext);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("Class " + evalStrategyClass + " could not be instantiated.", e);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unexpected error while instantiating " + evalStrategyClass + ":", e);
        }
    }
}

