/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.Objects;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.LoggingCloseableIteration;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeHelper;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationExecutionLogger;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTupleHelper;

public class LeftOuterJoin
implements PlanNode {
    private final PlanNode left;
    private final PlanNode right;
    private boolean printed = false;
    private ValidationExecutionLogger validationExecutionLogger;

    public LeftOuterJoin(PlanNode left, PlanNode right) {
        left = PlanNodeHelper.handleSorting(this, left);
        right = PlanNodeHelper.handleSorting(this, right);
        this.left = left;
        this.right = right;
    }

    @Override
    public CloseableIteration<? extends ValidationTuple, SailException> iterator() {
        return new LoggingCloseableIteration(this, this.validationExecutionLogger){
            final CloseableIteration<? extends ValidationTuple, SailException> leftIterator;
            final CloseableIteration<? extends ValidationTuple, SailException> rightIterator;
            ValidationTuple next;
            ValidationTuple nextLeft;
            ValidationTuple nextRight;
            ValidationTuple prevLeft;
            {
                this.leftIterator = LeftOuterJoin.this.left.iterator();
                this.rightIterator = LeftOuterJoin.this.right.iterator();
            }

            void calculateNext() {
                if (this.next != null) {
                    return;
                }
                if (this.nextLeft == null && this.leftIterator.hasNext()) {
                    this.nextLeft = (ValidationTuple)this.leftIterator.next();
                }
                if (this.nextLeft == null) {
                    return;
                }
                if (this.nextRight == null && this.rightIterator.hasNext()) {
                    this.nextRight = (ValidationTuple)this.rightIterator.next();
                }
                while (this.next == null) {
                    if (this.nextRight != null) {
                        if (this.nextLeft.sameTargetAs(this.nextRight)) {
                            this.next = ValidationTupleHelper.join(this.nextLeft, this.nextRight);
                            this.prevLeft = this.nextLeft;
                            this.nextRight = null;
                            continue;
                        }
                        int compareTo = this.nextLeft.compareActiveTarget(this.nextRight);
                        if (compareTo < 0) {
                            if (this.prevLeft != this.nextLeft) {
                                this.prevLeft = this.nextLeft;
                                this.next = this.nextLeft;
                                continue;
                            }
                            if (this.leftIterator.hasNext()) {
                                this.nextLeft = (ValidationTuple)this.leftIterator.next();
                                continue;
                            }
                            this.nextLeft = null;
                            break;
                        }
                        if (this.rightIterator.hasNext()) {
                            this.nextRight = (ValidationTuple)this.rightIterator.next();
                            continue;
                        }
                        this.nextRight = null;
                        continue;
                    }
                    if (this.prevLeft == this.nextLeft) {
                        if (!this.leftIterator.hasNext()) break;
                        this.nextLeft = (ValidationTuple)this.leftIterator.next();
                        continue;
                    }
                    this.prevLeft = this.nextLeft;
                    this.next = this.nextLeft;
                }
            }

            @Override
            public void localClose() throws SailException {
                this.leftIterator.close();
                this.rightIterator.close();
            }

            @Override
            protected boolean localHasNext() throws SailException {
                this.calculateNext();
                return this.next != null;
            }

            @Override
            protected ValidationTuple loggingNext() throws SailException {
                this.calculateNext();
                ValidationTuple temp = this.next;
                this.next = null;
                return temp;
            }
        };
    }

    @Override
    public int depth() {
        return Math.max(this.left.depth(), this.right.depth());
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        if (this.printed) {
            return;
        }
        this.printed = true;
        this.left.getPlanAsGraphvizDot(stringBuilder);
        stringBuilder.append(this.getId() + " [label=\"" + StringEscapeUtils.escapeJava((String)this.toString()) + "\"];").append("\n");
        stringBuilder.append(this.left.getId() + " -> " + this.getId() + " [label=\"left\"];").append("\n");
        stringBuilder.append(this.right.getId() + " -> " + this.getId() + " [label=\"right\"];").append("\n");
        this.right.getPlanAsGraphvizDot(stringBuilder);
    }

    @Override
    public String getId() {
        return System.identityHashCode(this) + "";
    }

    public String toString() {
        return "LeftOuterJoin";
    }

    @Override
    public void receiveLogger(ValidationExecutionLogger validationExecutionLogger) {
        this.validationExecutionLogger = validationExecutionLogger;
        this.left.receiveLogger(validationExecutionLogger);
        this.right.receiveLogger(validationExecutionLogger);
    }

    @Override
    public boolean producesSorted() {
        return true;
    }

    @Override
    public boolean requiresSorted() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LeftOuterJoin that = (LeftOuterJoin)o;
        return this.left.equals(that.left) && this.right.equals(that.right);
    }

    public int hashCode() {
        return Objects.hash(this.left, this.right);
    }
}

