/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.parser.serql;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.parser.serql.AbstractASTVisitor;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTProjectionElem;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTQueryContainer;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTSelect;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTVar;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTWhere;
import org.eclipse.rdf4j.query.parser.serql.ast.Node;
import org.eclipse.rdf4j.query.parser.serql.ast.VisitorException;

class ProjectionProcessor
extends AbstractASTVisitor {
    ProjectionProcessor() {
    }

    public static void process(ASTQueryContainer qc) throws MalformedQueryException {
        try {
            qc.jjtAccept(new ProjectionProcessor(), null);
        }
        catch (VisitorException e) {
            throw new MalformedQueryException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Object visit(ASTSelect selectNode, Object data) throws VisitorException {
        Set<String> bodyVars = VariableCollector.process(selectNode.jjtGetParent());
        if (selectNode.isWildcard()) {
            for (String varName : bodyVars) {
                ASTProjectionElem projElemNode = new ASTProjectionElem(11);
                selectNode.jjtAppendChild(projElemNode);
                projElemNode.jjtSetParent(selectNode);
                ASTVar varNode = new ASTVar(51);
                varNode.setName(varName);
                projElemNode.jjtAppendChild(varNode);
                varNode.jjtSetParent(projElemNode);
            }
            selectNode.setWildcard(false);
        } else {
            LinkedHashSet<String> projVars = new LinkedHashSet<String>();
            for (ASTProjectionElem projElem : selectNode.getProjectionElemList()) {
                projVars.addAll(VariableCollector.process(projElem.getValueExpr()));
            }
            projVars.removeAll(bodyVars);
            if (!projVars.isEmpty()) {
                StringBuilder errMsg = new StringBuilder(64);
                errMsg.append("Unbound variable(s) in projection: ");
                Iterator iter = projVars.iterator();
                while (iter.hasNext()) {
                    errMsg.append((String)iter.next());
                    if (!iter.hasNext()) continue;
                    errMsg.append(", ");
                }
                throw new VisitorException(errMsg.toString());
            }
        }
        return data;
    }

    private static class VariableCollector
    extends AbstractASTVisitor {
        private Set<String> variableNames = new LinkedHashSet<String>();

        private VariableCollector() {
        }

        public static Set<String> process(Node node) throws VisitorException {
            VariableCollector visitor = new VariableCollector();
            node.jjtAccept(visitor, null);
            return visitor.getVariableNames();
        }

        public Set<String> getVariableNames() {
            return this.variableNames;
        }

        @Override
        public Object visit(ASTSelect node, Object data) throws VisitorException {
            return data;
        }

        @Override
        public Object visit(ASTWhere node, Object data) throws VisitorException {
            return data;
        }

        @Override
        public Object visit(ASTVar node, Object data) throws VisitorException {
            this.variableNames.add(node.getName());
            return super.visit(node, data);
        }
    }
}

