/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.endpoint;

import java.util.Arrays;
import java.util.List;

public enum EndpointType {
    NativeStore(Arrays.asList("NativeStore", "lsail/NativeStore")),
    SparqlEndpoint(Arrays.asList("SparqlEndpoint", "api/sparql")),
    RemoteRepository(Arrays.asList("RemoteRepository")),
    Other(Arrays.asList("Other"));

    private List<String> formatNames;

    private EndpointType(List<String> formatNames) {
        this.formatNames = formatNames;
    }

    public boolean supportsFormat(String format) {
        return this.formatNames.contains(format);
    }

    public static boolean isSupportedFormat(String format) {
        if (format == null) {
            return false;
        }
        for (EndpointType e : EndpointType.values()) {
            if (!e.supportsFormat(format)) continue;
            return true;
        }
        return false;
    }
}

