/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.federation;

import java.util.List;
import java.util.Random;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.federation.AbstractEchoWriteConnection;
import org.eclipse.rdf4j.sail.federation.Federation;

class WritableConnection
extends AbstractEchoWriteConnection {
    private int addIndex;

    public WritableConnection(Federation federation, List<RepositoryConnection> members) throws SailException {
        super(federation, members);
        int rnd;
        int size = members.size();
        int n = rnd + size;
        for (int i = rnd = (new Random().nextInt() % size + size) % size; i < n; ++i) {
            try {
                if (!members.get(i % size).getRepository().isWritable()) continue;
                this.addIndex = i % size;
                continue;
            }
            catch (RepositoryException e) {
                throw new SailException((Throwable)e);
            }
        }
    }

    public void addStatementInternal(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        this.add((RepositoryConnection)this.members.get(this.addIndex), subj, pred, obj, contexts);
    }

    private void add(RepositoryConnection member, Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        try {
            member.add(subj, pred, obj, contexts);
        }
        catch (RepositoryException e) {
            throw new SailException((Throwable)e);
        }
    }

    protected void clearInternal(Resource ... contexts) throws SailException {
        this.removeStatementsInternal(null, null, null, contexts);
    }

    public boolean pendingRemovals() {
        return false;
    }
}

