/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.http.server.repository.config;

import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.rdf4j.http.server.ServerHTTPException;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.Rio;
import org.springframework.web.servlet.View;

public class ConfigView
implements View {
    public static final String CONFIG_DATA_KEY = "configData";
    public static final String FORMAT_KEY = "format";
    public static final String HEADERS_ONLY = "headersOnly";
    private static final ConfigView INSTANCE = new ConfigView();

    public static ConfigView getInstance() {
        return INSTANCE;
    }

    private ConfigView() {
    }

    public String getContentType() {
        return null;
    }

    public void render(Map model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean headersOnly = (Boolean)model.get(HEADERS_ONLY);
        RDFFormat rdfFormat = (RDFFormat)model.get(FORMAT_KEY);
        try (ServletOutputStream out = response.getOutputStream();){
            response.setStatus(200);
            String mimeType = rdfFormat.getDefaultMIMEType();
            if (rdfFormat.hasCharset()) {
                Charset charset = rdfFormat.getCharset();
                mimeType = mimeType + "; charset=" + charset.name();
            }
            response.setContentType(mimeType);
            String filename = "config";
            if (rdfFormat.getDefaultFileExtension() != null) {
                filename = filename + "." + rdfFormat.getDefaultFileExtension();
            }
            response.setHeader("Content-Disposition", "attachment; filename=" + filename);
            if (!headersOnly) {
                Model configuration = (Model)model.get(CONFIG_DATA_KEY);
                Rio.write((Iterable<Statement>)configuration, (OutputStream)out, rdfFormat);
            }
        }
        catch (RDFHandlerException e) {
            throw new ServerHTTPException("Serialization error: " + e.getMessage(), (Throwable)e);
        }
        catch (RepositoryException e) {
            throw new ServerHTTPException("Repository error: " + e.getMessage(), (Throwable)e);
        }
    }
}

