/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.impl;

import java.util.HashSet;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.MutableBindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.ExtensionElem;
import org.eclipse.rdf4j.query.algebra.MultiProjection;
import org.eclipse.rdf4j.query.algebra.ProjectionElem;
import org.eclipse.rdf4j.query.algebra.QueryRoot;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.ZeroLengthPath;
import org.eclipse.rdf4j.query.algebra.evaluation.ArrayBindingSet;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.QueryEvaluationContext;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;

public final class ArrayBindingBasedQueryEvaluationContext
implements QueryEvaluationContext {
    private final QueryEvaluationContext context;
    private final String[] allVariables;

    ArrayBindingBasedQueryEvaluationContext(QueryEvaluationContext context, String[] allVariables) {
        this.context = context;
        this.allVariables = allVariables;
    }

    @Override
    public Literal getNow() {
        return this.context.getNow();
    }

    @Override
    public Dataset getDataset() {
        return this.context.getDataset();
    }

    @Override
    public ArrayBindingSet createBindingSet() {
        return new ArrayBindingSet(this.allVariables);
    }

    @Override
    public Predicate<BindingSet> hasBinding(String variableName) {
        Function<ArrayBindingSet, Boolean> directHasVariable = new ArrayBindingSet(this.allVariables).getDirectHasBinding(variableName);
        return bs -> {
            if (bs instanceof ArrayBindingSet) {
                return (Boolean)directHasVariable.apply((ArrayBindingSet)bs);
            }
            return bs.hasBinding(variableName);
        };
    }

    @Override
    public Function<BindingSet, Binding> getBinding(String variableName) {
        ArrayBindingSet abs = new ArrayBindingSet(this.allVariables);
        Function<ArrayBindingSet, Binding> directAccessForVariable = abs.getDirectGetBinding(variableName);
        return bs -> {
            if (bs instanceof ArrayBindingSet) {
                return (Binding)directAccessForVariable.apply((ArrayBindingSet)bs);
            }
            return bs.getBinding(variableName);
        };
    }

    @Override
    public Function<BindingSet, Value> getValue(String variableName) {
        ArrayBindingSet abs = new ArrayBindingSet(this.allVariables);
        Function<ArrayBindingSet, Value> directAccessForVariable = abs.getDirectGetValue(variableName);
        return bs -> {
            if (bs instanceof ArrayBindingSet) {
                return (Value)directAccessForVariable.apply((ArrayBindingSet)bs);
            }
            return bs.getValue(variableName);
        };
    }

    @Override
    public BiConsumer<Value, MutableBindingSet> setBinding(String variableName) {
        ArrayBindingSet abs = new ArrayBindingSet(this.allVariables);
        BiConsumer<Value, ArrayBindingSet> directAccessForVariable = abs.getDirectSetBinding(variableName);
        return (val, bs) -> {
            if (bs instanceof ArrayBindingSet) {
                directAccessForVariable.accept((Value)val, (ArrayBindingSet)bs);
            } else {
                bs.setBinding(variableName, (Value)val);
            }
        };
    }

    @Override
    public BiConsumer<Value, MutableBindingSet> addBinding(String variableName) {
        BiConsumer<Value, ArrayBindingSet> wrapped = new ArrayBindingSet(this.allVariables).getDirectAddBinding(variableName);
        return (val, bs) -> {
            if (bs instanceof ArrayBindingSet) {
                wrapped.accept((Value)val, (ArrayBindingSet)bs);
            } else {
                bs.addBinding(variableName, (Value)val);
            }
        };
    }

    @Override
    public ArrayBindingSet createBindingSet(BindingSet bindings) {
        return new ArrayBindingSet(bindings, this.allVariables);
    }

    public static String[] findAllVariablesUsedInQuery(QueryRoot node) {
        final HashSet varNames = new HashSet();
        AbstractQueryModelVisitor<QueryEvaluationException> queryModelVisitorBase = new AbstractQueryModelVisitor<QueryEvaluationException>(){

            @Override
            public void meet(Var node) throws QueryEvaluationException {
                super.meet(node);
                varNames.add(node.getName());
            }

            @Override
            public void meet(ProjectionElem node) throws QueryEvaluationException {
                varNames.add(node.getSourceName());
                varNames.add(node.getTargetName());
                super.meet(node);
            }

            @Override
            public void meet(MultiProjection node) throws QueryEvaluationException {
                varNames.addAll(node.getBindingNames());
                super.meet(node);
            }

            @Override
            public void meet(ZeroLengthPath node) throws QueryEvaluationException {
                varNames.add("zero-length-internal-start");
                varNames.add("zero-length-internal-pred");
                varNames.add("zero-length-internal-end");
                varNames.add("zero-length-internal-seq");
                super.meet(node);
            }

            @Override
            public void meet(ExtensionElem node) throws QueryEvaluationException {
                varNames.add(node.getName());
                super.meet(node);
            }
        };
        node.visit(queryModelVisitorBase);
        String[] varNamesArr = varNames.toArray(new String[0]);
        return varNamesArr;
    }
}

