/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.rdf4j.common.lang.FileFormat;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;

public class RDFFormat
extends FileFormat {
    public static final boolean SUPPORTS_NAMESPACES = true;
    public static final boolean NO_NAMESPACES = false;
    public static final boolean SUPPORTS_CONTEXTS = true;
    public static final boolean NO_CONTEXTS = false;
    public static final boolean SUPPORTS_RDF_STAR = true;
    public static final boolean NO_RDF_STAR = false;
    public static final RDFFormat RDFXML = new RDFFormat("RDF/XML", Arrays.asList("application/rdf+xml", "application/xml", "text/xml"), StandardCharsets.UTF_8, Arrays.asList("rdf", "rdfs", "owl", "xml"), SimpleValueFactory.getInstance().createIRI("http://www.w3.org/ns/formats/RDF_XML"), true, false, false);
    public static final RDFFormat NTRIPLES = new RDFFormat("N-Triples", Arrays.asList("application/n-triples", "text/plain"), StandardCharsets.UTF_8, Arrays.asList("nt"), SimpleValueFactory.getInstance().createIRI("http://www.w3.org/ns/formats/N-Triples"), false, false, false);
    public static final RDFFormat TURTLE = new RDFFormat("Turtle", Arrays.asList("text/turtle", "application/x-turtle"), StandardCharsets.UTF_8, Arrays.asList("ttl"), SimpleValueFactory.getInstance().createIRI("http://www.w3.org/ns/formats/Turtle"), true, false, false);
    public static final RDFFormat TURTLESTAR = new RDFFormat("Turtle-star", Arrays.asList("text/x-turtlestar", "application/x-turtlestar"), StandardCharsets.UTF_8, Arrays.asList("ttls"), true, false, true);
    public static final RDFFormat N3 = new RDFFormat("N3", Arrays.asList("text/n3", "text/rdf+n3"), StandardCharsets.UTF_8, Arrays.asList("n3"), SimpleValueFactory.getInstance().createIRI("http://www.w3.org/ns/formats/N3"), true, false, false);
    public static final RDFFormat TRIX = new RDFFormat("TriX", Arrays.asList("application/trix"), StandardCharsets.UTF_8, Arrays.asList("xml", "trix"), null, true, true, false);
    public static final RDFFormat TRIG = new RDFFormat("TriG", Arrays.asList("application/trig", "application/x-trig"), StandardCharsets.UTF_8, Arrays.asList("trig"), SimpleValueFactory.getInstance().createIRI("http://www.w3.org/ns/formats/TriG"), true, true, false);
    public static final RDFFormat TRIGSTAR = new RDFFormat("TriG-star", "application/x-trigstar", StandardCharsets.UTF_8, "trigs", true, true, true);
    public static final RDFFormat BINARY = new RDFFormat("BinaryRDF", Arrays.asList("application/x-binary-rdf"), null, Arrays.asList("brf"), null, true, true, true);
    public static final RDFFormat NQUADS = new RDFFormat("N-Quads", Arrays.asList("application/n-quads", "text/x-nquads", "text/nquads"), StandardCharsets.UTF_8, Arrays.asList("nq"), SimpleValueFactory.getInstance().createIRI("http://www.w3.org/ns/formats/N-Quads"), false, true, false);
    public static final RDFFormat JSONLD = new RDFFormat("JSON-LD", Arrays.asList("application/ld+json"), StandardCharsets.UTF_8, Arrays.asList("jsonld"), SimpleValueFactory.getInstance().createIRI("http://www.w3.org/ns/formats/JSON-LD"), true, true, false);
    public static final RDFFormat NDJSONLD = new RDFFormat("NDJSON-LD", Arrays.asList("application/x-ld+ndjson"), StandardCharsets.UTF_8, Arrays.asList("ndjsonld", "jsonl", "ndjson"), null, true, true, false);
    public static final RDFFormat RDFJSON = new RDFFormat("RDF/JSON", Arrays.asList("application/rdf+json"), StandardCharsets.UTF_8, Arrays.asList("rj"), SimpleValueFactory.getInstance().createIRI("http://www.w3.org/ns/formats/RDF_JSON"), false, true, false);
    public static final RDFFormat RDFA = new RDFFormat("RDFa", Arrays.asList("application/xhtml+xml", "application/html", "text/html"), StandardCharsets.UTF_8, Arrays.asList("xhtml", "html"), SimpleValueFactory.getInstance().createIRI("http://www.w3.org/ns/formats/RDFa"), true, false, false);
    public static final RDFFormat HDT = new RDFFormat("HDT", Arrays.asList("application/vnd.hdt"), null, Arrays.asList("hdt"), null, true, false, false);
    private final boolean supportsNamespaces;
    private final boolean supportsContexts;
    private final boolean supportsRDFStar;
    private IRI standardURI;

    public static List<String> getAcceptParams(Iterable<RDFFormat> rdfFormats, boolean requireContext, RDFFormat preferredFormat) {
        ArrayList<String> acceptParams = new ArrayList<String>();
        for (RDFFormat format : rdfFormats) {
            int qValue = 10;
            if (requireContext && !format.supportsContexts()) {
                qValue -= 5;
            }
            if (preferredFormat != null && !preferredFormat.equals(format)) {
                qValue -= 2;
            }
            if (!format.supportsNamespaces()) {
                --qValue;
            }
            if (RDFXML.equals(format)) {
                qValue -= 4;
            }
            qValue = Math.max(1, qValue);
            for (String mimeType : format.getMIMETypes()) {
                Object acceptParam = mimeType;
                if (qValue < 10) {
                    acceptParam = (String)acceptParam + ";q=0." + qValue;
                }
                acceptParams.add((String)acceptParam);
            }
        }
        return acceptParams;
    }

    @Deprecated
    public RDFFormat(String name, String mimeType, Charset charset, String fileExtension, boolean supportsNamespaces, boolean supportsContexts) {
        this(name, mimeType, charset, fileExtension, supportsNamespaces, supportsContexts, false);
    }

    public RDFFormat(String name, String mimeType, Charset charset, String fileExtension, boolean supportsNamespaces, boolean supportsContexts, boolean supportsRDFStar) {
        this(name, Arrays.asList(mimeType), charset, Arrays.asList(fileExtension), supportsNamespaces, supportsContexts, supportsRDFStar);
    }

    @Deprecated
    public RDFFormat(String name, String mimeType, Charset charset, Collection<String> fileExtensions, boolean supportsNamespaces, boolean supportsContexts) {
        this(name, mimeType, charset, fileExtensions, supportsNamespaces, supportsContexts, false);
    }

    public RDFFormat(String name, String mimeType, Charset charset, Collection<String> fileExtensions, boolean supportsNamespaces, boolean supportsContexts, boolean supportsRDFStar) {
        this(name, Arrays.asList(mimeType), charset, fileExtensions, supportsNamespaces, supportsContexts, supportsRDFStar);
    }

    @Deprecated
    public RDFFormat(String name, Collection<String> mimeTypes, Charset charset, Collection<String> fileExtensions, boolean supportsNamespaces, boolean supportsContexts) {
        this(name, mimeTypes, charset, fileExtensions, null, supportsNamespaces, supportsContexts, false);
    }

    public RDFFormat(String name, Collection<String> mimeTypes, Charset charset, Collection<String> fileExtensions, boolean supportsNamespaces, boolean supportsContexts, boolean supportsRDFStar) {
        this(name, mimeTypes, charset, fileExtensions, null, supportsNamespaces, supportsContexts, supportsRDFStar);
    }

    @Deprecated
    public RDFFormat(String name, Collection<String> mimeTypes, Charset charset, Collection<String> fileExtensions, IRI standardURI, boolean supportsNamespaces, boolean supportsContexts) {
        this(name, mimeTypes, charset, fileExtensions, standardURI, supportsNamespaces, supportsContexts, false);
    }

    public RDFFormat(String name, Collection<String> mimeTypes, Charset charset, Collection<String> fileExtensions, IRI standardURI, boolean supportsNamespaces, boolean supportsContexts, boolean supportsRDFStar) {
        super(name, mimeTypes, charset, fileExtensions);
        this.standardURI = standardURI;
        this.supportsNamespaces = supportsNamespaces;
        this.supportsContexts = supportsContexts;
        this.supportsRDFStar = supportsRDFStar;
    }

    public boolean supportsNamespaces() {
        return this.supportsNamespaces;
    }

    public boolean supportsContexts() {
        return this.supportsContexts;
    }

    public boolean supportsRDFStar() {
        return this.supportsRDFStar;
    }

    public boolean hasStandardURI() {
        return this.standardURI != null;
    }

    public IRI getStandardURI() {
        return this.standardURI;
    }
}

