/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.memory.model;

import java.lang.ref.WeakReference;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeakObjectRegistry<E>
extends AbstractSet<E> {
    private static final Logger logger = LoggerFactory.getLogger(WeakObjectRegistry.class);
    private final Map<E, WeakReference<E>>[] objectMap;
    private final StampedLock[] locks;

    public WeakObjectRegistry() {
        int i;
        int concurrency = Runtime.getRuntime().availableProcessors() * 2;
        this.objectMap = new WeakHashMap[concurrency];
        for (i = 0; i < this.objectMap.length; ++i) {
            this.objectMap[i] = new WeakHashMap<E, WeakReference<E>>();
        }
        this.locks = new StampedLock[this.objectMap.length];
        for (i = 0; i < this.locks.length; ++i) {
            this.locks[i] = new StampedLock();
        }
    }

    public WeakObjectRegistry(Collection<? extends E> c) {
        this();
        this.addAll(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E get(Object key) {
        if (key == null) {
            return null;
        }
        int index = this.getIndex(key);
        long readLock = this.locks[index].readLock();
        try {
            Map<E, WeakReference<E>> weakReferenceMap = this.objectMap[index];
            WeakReference<E> weakRef = weakReferenceMap.get(key);
            if (weakRef != null) {
                Object t = weakRef.get();
                return (E)t;
            }
            E e = null;
            return e;
        }
        finally {
            this.locks[index].unlockRead(readLock);
        }
    }

    private int getIndex(Object key) {
        int i = Math.abs(key.hashCode());
        return i % this.objectMap.length;
    }

    public AutoCloseableIterator<E> closeableIterator() {
        return new AutoCloseableIterator<E>(this.objectMap, this.locks);
    }

    @Override
    public Iterator<E> iterator() {
        logger.warn("This method is not thread safe! Use closeableIterator() instead.");
        return new AutoCloseableIterator<E>(this.objectMap, null);
    }

    @Override
    public int size() {
        int size = 0;
        for (Map<E, WeakReference<E>> weakReferenceMap : this.objectMap) {
            size += weakReferenceMap.size();
        }
        return size;
    }

    @Override
    public boolean contains(Object key) {
        return this.get(key) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(E object) {
        int index = this.getIndex(object);
        long writeLock = this.locks[index].writeLock();
        try {
            Object e;
            Map<E, WeakReference<E>> weakReferenceMap = this.objectMap[index];
            WeakReference<E> ref = new WeakReference<E>(object);
            ref = weakReferenceMap.put(object, ref);
            if (ref != null && (e = ref.get()) != null) {
                weakReferenceMap.put(e, ref);
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.locks[index].unlockWrite(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E getOrAdd(Object key, Supplier<E> supplier) {
        int index = this.getIndex(key);
        Map<E, WeakReference<E>> weakReferenceMap = this.objectMap[index];
        long readLock = this.locks[index].readLock();
        try {
            Object e;
            WeakReference<E> ref = weakReferenceMap.get(key);
            if (ref != null && (e = ref.get()) != null) {
                Object t = e;
                return (E)t;
            }
        }
        finally {
            this.locks[index].unlockRead(readLock);
        }
        long writeLock = this.locks[index].writeLock();
        try {
            Object e;
            E object = supplier.get();
            WeakReference<E> ref = weakReferenceMap.put(object, new WeakReference<E>(object));
            if (ref != null && (e = ref.get()) != null) {
                weakReferenceMap.put(e, ref);
                Object t = e;
                return (E)t;
            }
            assert (object != null);
            E e2 = object;
            return e2;
        }
        finally {
            this.locks[index].unlockWrite(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object object) {
        int index = this.getIndex(object);
        long writeLock = this.locks[index].writeLock();
        try {
            Map<E, WeakReference<E>> weakReferenceMap = this.objectMap[index];
            WeakReference<E> ref = weakReferenceMap.remove(object);
            boolean bl = ref != null && ref.get() != null;
            return bl;
        }
        finally {
            this.locks[index].unlockWrite(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        for (int i = 0; i < this.objectMap.length; ++i) {
            long writeLock = this.locks[i].writeLock();
            try {
                this.objectMap[i].clear();
                continue;
            }
            finally {
                this.locks[i].unlockWrite(writeLock);
            }
        }
    }

    public static class AutoCloseableIterator<E>
    implements Iterator<E>,
    AutoCloseable {
        private final Iterator<Map<E, WeakReference<E>>> iterator;
        private final StampedLock[] locks;
        Iterator<E> currentIterator;
        Long[] readLocks;
        boolean init = false;

        public AutoCloseableIterator(Map<E, WeakReference<E>>[] objectMap, StampedLock[] locks) {
            this.iterator = Arrays.asList(objectMap).iterator();
            this.locks = locks;
        }

        public void init() {
            if (!this.init) {
                this.init = true;
                if (this.locks != null) {
                    this.readLocks = new Long[this.locks.length];
                    for (int i = 0; i < this.locks.length; ++i) {
                        this.readLocks[i] = this.locks[i].readLock();
                    }
                }
                this.currentIterator = this.iterator.next().keySet().iterator();
            }
        }

        @Override
        public boolean hasNext() {
            this.init();
            if (this.currentIterator == null) {
                return false;
            }
            while (this.currentIterator != null) {
                if (this.currentIterator.hasNext()) {
                    return true;
                }
                this.currentIterator = null;
                if (!this.iterator.hasNext()) continue;
                this.currentIterator = this.iterator.next().keySet().iterator();
            }
            return false;
        }

        @Override
        public E next() {
            this.init();
            return this.currentIterator.next();
        }

        @Override
        public void close() {
            if (this.init && this.locks != null) {
                for (int i = 0; i < this.locks.length; ++i) {
                    if (this.readLocks[i] == 0L) continue;
                    this.locks[i].unlockRead(this.readLocks[i]);
                    this.readLocks[i] = 0L;
                }
            }
        }
    }
}

