/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lmdb;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.eclipse.rdf4j.sail.lmdb.LmdbUtil;
import org.eclipse.rdf4j.sail.lmdb.Pool;
import org.eclipse.rdf4j.sail.lmdb.Record;
import org.eclipse.rdf4j.sail.lmdb.RecordIterator;
import org.eclipse.rdf4j.sail.lmdb.TripleStore;
import org.eclipse.rdf4j.sail.lmdb.TxnRef;
import org.eclipse.rdf4j.sail.lmdb.Varint;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.util.lmdb.LMDB;
import org.lwjgl.util.lmdb.MDBVal;

class LmdbRecordIterator
implements RecordIterator {
    private final Pool pool;
    private final TripleStore.TripleIndex index;
    private final long cursor;
    private final MDBVal maxKey;
    private final Varint.GroupMatcher groupMatcher;
    private final TxnRef txnRef;
    private final long txn;
    private final int dbi;
    private boolean closed = false;
    private final MDBVal keyData;
    private final MDBVal valueData;
    private ByteBuffer minKeyBuf;
    private ByteBuffer maxKeyBuf;
    private int lastResult;
    private boolean fetchNext = false;

    LmdbRecordIterator(Pool pool, TripleStore.TripleIndex index, boolean rangeSearch, long subj, long pred, long obj, long context, boolean explicit, TxnRef txnRef) {
        this.pool = pool;
        this.keyData = pool.getVal();
        this.valueData = pool.getVal();
        this.index = index;
        if (rangeSearch) {
            this.minKeyBuf = pool.getKeyBuffer();
            index.getMinKey(this.minKeyBuf, subj, pred, obj, context);
            this.minKeyBuf.flip();
            this.maxKey = pool.getVal();
            this.maxKeyBuf = pool.getKeyBuffer();
            index.getMaxKey(this.maxKeyBuf, subj, pred, obj, context);
            this.maxKeyBuf.flip();
            this.maxKey.mv_data(this.maxKeyBuf);
        } else {
            this.minKeyBuf = null;
            this.maxKey = null;
        }
        boolean matchValues = subj > 0L || pred > 0L || obj > 0L || context >= 0L;
        this.groupMatcher = matchValues ? index.createMatcher(subj, pred, obj, context) : null;
        this.txnRef = txnRef;
        this.txn = txnRef.create();
        this.dbi = index.getDB(explicit);
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer pp = stack.mallocPointer(1);
            LmdbUtil.E(LMDB.mdb_cursor_open((long)this.txn, (int)this.dbi, (PointerBuffer)pp));
            this.cursor = pp.get(0);
        }
        if (this.minKeyBuf != null) {
            this.keyData.mv_data(this.minKeyBuf);
            this.lastResult = LMDB.mdb_cursor_get((long)this.cursor, (MDBVal)this.keyData, (MDBVal)this.valueData, (int)17);
        } else {
            this.lastResult = LMDB.mdb_cursor_get((long)this.cursor, (MDBVal)this.keyData, (MDBVal)this.valueData, (int)8);
        }
    }

    @Override
    public Record next() throws IOException {
        if (this.fetchNext) {
            this.lastResult = LMDB.mdb_cursor_get((long)this.cursor, (MDBVal)this.keyData, (MDBVal)this.valueData, (int)8);
            this.fetchNext = false;
        }
        while (this.lastResult == 0) {
            if (this.maxKey != null && LMDB.mdb_cmp((long)this.txn, (int)this.dbi, (MDBVal)this.keyData, (MDBVal)this.maxKey) > 0) {
                this.lastResult = -30798;
                continue;
            }
            if (this.groupMatcher != null && !this.groupMatcher.matches(this.keyData.mv_data())) {
                this.lastResult = LMDB.mdb_cursor_get((long)this.cursor, (MDBVal)this.keyData, (MDBVal)this.valueData, (int)8);
                continue;
            }
            Record record = new Record(this.keyData.mv_data(), this.valueData.mv_data(), this.index::keyToQuad);
            this.fetchNext = true;
            return record;
        }
        this.close();
        return null;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            try {
                LMDB.mdb_cursor_close((long)this.cursor);
                this.pool.free(this.keyData);
                this.pool.free(this.valueData);
                if (this.minKeyBuf != null) {
                    this.pool.free(this.minKeyBuf);
                }
                if (this.maxKey != null) {
                    this.pool.free(this.maxKeyBuf);
                    this.pool.free(this.maxKey);
                }
                this.txnRef.free(this.txn);
            }
            finally {
                this.closed = true;
            }
        }
    }
}

