/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lmdb;

import java.io.IOException;
import org.eclipse.rdf4j.common.iteration.LookAheadIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.lmdb.Record;
import org.eclipse.rdf4j.sail.lmdb.RecordIterator;
import org.eclipse.rdf4j.sail.lmdb.ValueStore;
import org.eclipse.rdf4j.sail.lmdb.model.LmdbValue;

class LmdbStatementIterator
extends LookAheadIteration<Statement, SailException> {
    private final RecordIterator recordIt;
    private final ValueStore valueStore;
    private final long[] quad = new long[4];

    public LmdbStatementIterator(RecordIterator recordIt, ValueStore valueStore) throws IOException {
        this.recordIt = recordIt;
        this.valueStore = valueStore;
    }

    public Statement getNextElement() throws SailException {
        try {
            Record nextRecord = this.recordIt.next();
            if (nextRecord == null) {
                return null;
            }
            nextRecord.toQuad(this.quad);
            long subjID = this.quad[0];
            Resource subj = (Resource)this.valueStore.getLazyValue(subjID);
            long predID = this.quad[1];
            IRI pred = (IRI)this.valueStore.getLazyValue(predID);
            long objID = this.quad[2];
            LmdbValue obj = this.valueStore.getLazyValue(objID);
            Resource context = null;
            long contextID = this.quad[3];
            if (contextID != 0L) {
                context = (Resource)this.valueStore.getLazyValue(contextID);
            }
            return this.valueStore.createStatement(subj, pred, obj, context);
        }
        catch (IOException e) {
            throw this.causeIOException(e);
        }
    }

    protected void handleClose() throws SailException {
        try {
            super.handleClose();
        }
        finally {
            try {
                this.recordIt.close();
            }
            catch (IOException e) {
                throw this.causeIOException(e);
            }
        }
    }

    protected SailException causeIOException(IOException e) {
        return new SailException((Throwable)e);
    }
}

