/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.iterator;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.rdf4j.common.iteration.FilterIteration;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryResults;

public class SPARQLMinusIteration<X extends Exception>
extends FilterIteration<BindingSet, X> {
    private final Iteration<BindingSet, X> rightArg;
    private boolean initialized;
    private Set<BindingSet> excludeSet;

    public SPARQLMinusIteration(Iteration<BindingSet, X> leftArg, Iteration<BindingSet, X> rightArg) {
        super(leftArg);
        assert (rightArg != null);
        this.rightArg = rightArg;
        this.initialized = false;
    }

    @Deprecated(since="4.0.0", forRemoval=true)
    public SPARQLMinusIteration(Iteration<BindingSet, X> leftArg, Iteration<BindingSet, X> rightArg, boolean distinct) {
        this(leftArg, rightArg);
    }

    @Override
    protected boolean accept(BindingSet object) throws X {
        if (!this.initialized) {
            this.excludeSet = this.makeSet(this.getRightArg());
            this.initialized = true;
        }
        boolean compatible = false;
        for (BindingSet excluded : this.excludeSet) {
            Set<String> sharedBindingNames = this.makeSet(excluded.getBindingNames());
            sharedBindingNames.retainAll(object.getBindingNames());
            if (sharedBindingNames.isEmpty() || !QueryResults.bindingSetsCompatible(excluded, object)) continue;
            compatible = true;
            break;
        }
        return !compatible;
    }

    protected Set<BindingSet> makeSet() throws X {
        return new LinkedHashSet<BindingSet>();
    }

    protected Set<String> makeSet(Set<String> set) throws X {
        return new HashSet<String>(set);
    }

    protected Set<BindingSet> makeSet(Iteration<BindingSet, X> rightArg2) throws X {
        return Iterations.asSet(this.rightArg);
    }

    @Override
    protected void handleClose() throws X {
        try {
            super.handleClose();
        }
        finally {
            Iterations.closeCloseable(this.getRightArg());
        }
    }

    protected Iteration<BindingSet, X> getRightArg() {
        return this.rightArg;
    }

    protected long clearExcludeSet() {
        int size = this.excludeSet.size();
        this.excludeSet.clear();
        return size;
    }
}

