/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.evaluation.join;

import java.util.ArrayList;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.federated.algebra.CheckStatementPattern;
import org.eclipse.rdf4j.federated.algebra.StatementTupleExpr;
import org.eclipse.rdf4j.federated.evaluation.FederationEvalStrategy;
import org.eclipse.rdf4j.federated.evaluation.join.SynchronousJoin;
import org.eclipse.rdf4j.federated.structures.QueryInfo;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SynchronousBoundJoin
extends SynchronousJoin {
    private static final Logger log = LoggerFactory.getLogger(SynchronousBoundJoin.class);

    public SynchronousBoundJoin(FederationEvalStrategy strategy, CloseableIteration<BindingSet, QueryEvaluationException> leftIter, TupleExpr rightArg, BindingSet bindings, QueryInfo queryInfo) throws QueryEvaluationException {
        super(strategy, leftIter, rightArg, bindings, queryInfo);
    }

    @Override
    protected void handleBindings() throws Exception {
        if (!(this.rightArg instanceof StatementPattern)) {
            log.warn("Right argument is not a StatementPattern. Fallback on SynchronousJoin implementation: " + this.rightArg.getClass().getCanonicalName());
            super.handleBindings();
            return;
        }
        int nBindingsCfg = this.queryInfo.getFederationContext().getConfig().getBoundJoinBlockSize();
        int totalBindings = 0;
        StatementTupleExpr stmt = (StatementTupleExpr)this.rightArg;
        boolean hasFreeVars = true;
        if (!this.isClosed() && this.leftIter.hasNext()) {
            BindingSet b = (BindingSet)this.leftIter.next();
            ++totalBindings;
            hasFreeVars = stmt.hasFreeVarsFor(b);
            if (!hasFreeVars) {
                stmt = new CheckStatementPattern(stmt, this.queryInfo);
            }
            this.addResult(this.strategy.evaluate(stmt, b));
        }
        ArrayList<BindingSet> bindings = null;
        while (!this.isClosed() && this.leftIter.hasNext()) {
            int count;
            int nBindings = totalBindings > 10 ? nBindingsCfg : 3;
            bindings = new ArrayList<BindingSet>(nBindings);
            for (count = 0; !this.isClosed() && count < nBindings && this.leftIter.hasNext(); ++count) {
                bindings.add((BindingSet)this.leftIter.next());
            }
            totalBindings += count;
            if (this.isClosed()) {
                return;
            }
            if (hasFreeVars) {
                this.addResult(this.strategy.evaluateBoundJoinStatementPattern(stmt, bindings));
                continue;
            }
            this.addResult(this.strategy.evaluateGroupedCheck((CheckStatementPattern)stmt, bindings));
        }
        if (log.isDebugEnabled()) {
            log.debug("JoinStats: left iter of " + this.getDisplayId() + " had " + totalBindings + " results.");
        }
    }
}

