/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation;

import java.util.function.Function;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.DelayedIteration;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategy;

@FunctionalInterface
public interface QueryEvaluationStep {
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(BindingSet var1);

    public static QueryEvaluationStep minimal(final EvaluationStrategy strategy, final TupleExpr expr) {
        return new QueryEvaluationStep(){

            @Override
            public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(BindingSet bs) {
                return strategy.evaluate(expr, bs);
            }
        };
    }

    public static QueryEvaluationStep wrap(final QueryEvaluationStep qes, final Function<CloseableIteration<BindingSet, QueryEvaluationException>, CloseableIteration<BindingSet, QueryEvaluationException>> wrap) {
        return new QueryEvaluationStep(){

            @Override
            public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(BindingSet bs) {
                return (CloseableIteration)wrap.apply(qes.evaluate(bs));
            }
        };
    }

    public static class DelayedEvaluationIteration
    extends DelayedIteration<BindingSet, QueryEvaluationException> {
        private final QueryEvaluationStep arg;
        private final BindingSet bs;

        public DelayedEvaluationIteration(QueryEvaluationStep arg, BindingSet bs) {
            this.arg = arg;
            this.bs = bs;
        }

        @Override
        protected Iteration<? extends BindingSet, ? extends QueryEvaluationException> createIteration() throws QueryEvaluationException {
            return this.arg.evaluate(this.bs);
        }
    }
}

