/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.memory.model;

import org.eclipse.rdf4j.model.impl.SimpleBNode;
import org.eclipse.rdf4j.sail.memory.model.MemResource;
import org.eclipse.rdf4j.sail.memory.model.MemStatement;
import org.eclipse.rdf4j.sail.memory.model.MemStatementList;

public class MemBNode
extends SimpleBNode
implements MemResource {
    private static final long serialVersionUID = -887382892580321647L;
    private final transient Object creator;
    private final transient MemStatementList subjectStatements = new MemStatementList();
    private final transient MemStatementList objectStatements = new MemStatementList();
    private final transient MemStatementList contextStatements = new MemStatementList();

    public MemBNode(Object creator, String id) {
        super(id);
        this.creator = creator;
    }

    @Override
    public Object getCreator() {
        return this.creator;
    }

    @Override
    public boolean hasStatements() {
        return !this.subjectStatements.isEmpty() || !this.objectStatements.isEmpty() || !this.contextStatements.isEmpty();
    }

    @Override
    public MemStatementList getSubjectStatementList() {
        return this.subjectStatements;
    }

    @Override
    public int getSubjectStatementCount() {
        return this.subjectStatements.size();
    }

    @Override
    public void addSubjectStatement(MemStatement st) {
        this.subjectStatements.add(st);
    }

    @Override
    public void removeSubjectStatement(MemStatement st) {
        this.subjectStatements.remove(st);
    }

    @Override
    public void cleanSnapshotsFromSubjectStatements(int currentSnapshot) {
        this.subjectStatements.cleanSnapshots(currentSnapshot);
    }

    @Override
    public MemStatementList getObjectStatementList() {
        return this.objectStatements;
    }

    @Override
    public int getObjectStatementCount() {
        return this.objectStatements.size();
    }

    @Override
    public void addObjectStatement(MemStatement st) {
        this.objectStatements.add(st);
    }

    @Override
    public void removeObjectStatement(MemStatement st) {
        this.objectStatements.remove(st);
    }

    @Override
    public void cleanSnapshotsFromObjectStatements(int currentSnapshot) {
        this.objectStatements.cleanSnapshots(currentSnapshot);
    }

    @Override
    public MemStatementList getContextStatementList() {
        return this.contextStatements;
    }

    @Override
    public int getContextStatementCount() {
        return this.contextStatements.size();
    }

    @Override
    public void addContextStatement(MemStatement st) {
        this.contextStatements.add(st);
    }

    @Override
    public void removeContextStatement(MemStatement st) {
        this.contextStatements.remove(st);
    }

    @Override
    public void cleanSnapshotsFromContextStatements(int currentSnapshot) {
        this.contextStatements.cleanSnapshots(currentSnapshot);
    }
}

