/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.Objects;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.base.CoreDatatype;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.FilterPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.Formatter;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;

public class DatatypeFilter
extends FilterPlanNode {
    private final IRI datatype;
    private final CoreDatatype.XSD xsdDatatype;
    private StackTraceElement[] stackTrace;

    public DatatypeFilter(PlanNode parent, IRI datatype) {
        super(parent);
        this.datatype = datatype;
        this.xsdDatatype = CoreDatatype.from(datatype).asXSDDatatype().orElse(null);
    }

    @Override
    boolean checkTuple(ValidationTuple t) {
        if (!t.getValue().isLiteral()) {
            return false;
        }
        Literal literal = (Literal)t.getValue();
        if (this.xsdDatatype != null) {
            if (literal.getCoreDatatype() == this.xsdDatatype) {
                boolean validValue = XMLDatatypeUtil.isValidValue(literal.stringValue(), this.xsdDatatype);
                return validValue;
            }
            return false;
        }
        return literal.getDatatype() == this.datatype || literal.getDatatype().equals(this.datatype);
    }

    @Override
    public String toString() {
        return "DatatypeFilter{datatype=" + Formatter.prefix(this.datatype) + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DatatypeFilter that = (DatatypeFilter)o;
        return this.datatype.equals(that.datatype);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.datatype);
    }
}

